package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, BillingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBillingGroupRequest(
    billingGroupName: BillingGroupName,
    billingGroupProperties: zio.aws.iot.model.BillingGroupProperties,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest = {
    import UpdateBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest
      .builder()
      .billingGroupName(
        BillingGroupName.unwrap(billingGroupName): java.lang.String
      )
      .billingGroupProperties(billingGroupProperties.buildAwsValue())
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.UpdateBillingGroupRequest.wrap(buildAwsValue())
}
object UpdateBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateBillingGroupRequest =
      zio.aws.iot.model.UpdateBillingGroupRequest(
        billingGroupName,
        billingGroupProperties.asEditable,
        expectedVersion.map(value => value)
      )
    def billingGroupName: BillingGroupName
    def billingGroupProperties
        : zio.aws.iot.model.BillingGroupProperties.ReadOnly
    def expectedVersion: Optional[OptionalVersion]
    def getBillingGroupName: ZIO[Any, Nothing, BillingGroupName] =
      ZIO.succeed(billingGroupName)
    def getBillingGroupProperties
        : ZIO[Any, Nothing, zio.aws.iot.model.BillingGroupProperties.ReadOnly] =
      ZIO.succeed(billingGroupProperties)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest
  ) extends zio.aws.iot.model.UpdateBillingGroupRequest.ReadOnly {
    override val billingGroupName: BillingGroupName =
      zio.aws.iot.model.primitives.BillingGroupName(impl.billingGroupName())
    override val billingGroupProperties
        : zio.aws.iot.model.BillingGroupProperties.ReadOnly =
      zio.aws.iot.model.BillingGroupProperties
        .wrap(impl.billingGroupProperties())
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest
  ): zio.aws.iot.model.UpdateBillingGroupRequest.ReadOnly = new Wrapper(impl)
}
