package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Version
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBillingGroupResponse(
    version: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse = {
    import UpdateBillingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly =
    zio.aws.iot.model.UpdateBillingGroupResponse.wrap(buildAwsValue())
}
object UpdateBillingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateBillingGroupResponse =
      zio.aws.iot.model.UpdateBillingGroupResponse(version.map(value => value))
    def version: Optional[Version]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse
  ) extends zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly {
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse
  ): zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly = new Wrapper(impl)
}
