package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RemoveAutoRegistration, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCaCertificateRequest(
    certificateId: CertificateId,
    newStatus: Optional[zio.aws.iot.model.CACertificateStatus] =
      Optional.Absent,
    newAutoRegistrationStatus: Optional[
      zio.aws.iot.model.AutoRegistrationStatus
    ] = Optional.Absent,
    registrationConfig: Optional[zio.aws.iot.model.RegistrationConfig] =
      Optional.Absent,
    removeAutoRegistration: Optional[RemoveAutoRegistration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest = {
    import UpdateCaCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(newStatus.map(value => value.unwrap))(_.newStatus)
      .optionallyWith(newAutoRegistrationStatus.map(value => value.unwrap))(
        _.newAutoRegistrationStatus
      )
      .optionallyWith(registrationConfig.map(value => value.buildAwsValue()))(
        _.registrationConfig
      )
      .optionallyWith(
        removeAutoRegistration.map(value =>
          RemoveAutoRegistration.unwrap(value): java.lang.Boolean
        )
      )(_.removeAutoRegistration)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateCaCertificateRequest.ReadOnly =
    zio.aws.iot.model.UpdateCaCertificateRequest.wrap(buildAwsValue())
}
object UpdateCaCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateCaCertificateRequest =
      zio.aws.iot.model.UpdateCaCertificateRequest(
        certificateId,
        newStatus.map(value => value),
        newAutoRegistrationStatus.map(value => value),
        registrationConfig.map(value => value.asEditable),
        removeAutoRegistration.map(value => value)
      )
    def certificateId: CertificateId
    def newStatus: Optional[zio.aws.iot.model.CACertificateStatus]
    def newAutoRegistrationStatus
        : Optional[zio.aws.iot.model.AutoRegistrationStatus]
    def registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly]
    def removeAutoRegistration: Optional[RemoveAutoRegistration]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getNewStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.CACertificateStatus] =
      AwsError.unwrapOptionField("newStatus", newStatus)
    def getNewAutoRegistrationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.AutoRegistrationStatus] =
      AwsError.unwrapOptionField(
        "newAutoRegistrationStatus",
        newAutoRegistrationStatus
      )
    def getRegistrationConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      AwsError.unwrapOptionField("registrationConfig", registrationConfig)
    def getRemoveAutoRegistration: ZIO[Any, AwsError, RemoveAutoRegistration] =
      AwsError.unwrapOptionField(
        "removeAutoRegistration",
        removeAutoRegistration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest
  ) extends zio.aws.iot.model.UpdateCaCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val newStatus: Optional[zio.aws.iot.model.CACertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newStatus())
        .map(value => zio.aws.iot.model.CACertificateStatus.wrap(value))
    override val newAutoRegistrationStatus
        : Optional[zio.aws.iot.model.AutoRegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newAutoRegistrationStatus())
        .map(value => zio.aws.iot.model.AutoRegistrationStatus.wrap(value))
    override val registrationConfig
        : Optional[zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationConfig())
        .map(value => zio.aws.iot.model.RegistrationConfig.wrap(value))
    override val removeAutoRegistration: Optional[RemoveAutoRegistration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeAutoRegistration())
        .map(value =>
          zio.aws.iot.model.primitives.RemoveAutoRegistration(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest
  ): zio.aws.iot.model.UpdateCaCertificateRequest.ReadOnly = new Wrapper(impl)
}
