package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CustomMetricDisplayName, MetricName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateCustomMetricRequest(
    metricName: MetricName,
    displayName: CustomMetricDisplayName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest = {
    import UpdateCustomMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .displayName(
        CustomMetricDisplayName.unwrap(displayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateCustomMetricRequest.ReadOnly =
    zio.aws.iot.model.UpdateCustomMetricRequest.wrap(buildAwsValue())
}
object UpdateCustomMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateCustomMetricRequest =
      zio.aws.iot.model.UpdateCustomMetricRequest(metricName, displayName)
    def metricName: MetricName
    def displayName: CustomMetricDisplayName
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getDisplayName: ZIO[Any, Nothing, CustomMetricDisplayName] =
      ZIO.succeed(displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest
  ) extends zio.aws.iot.model.UpdateCustomMetricRequest.ReadOnly {
    override val metricName: MetricName =
      zio.aws.iot.model.primitives.MetricName(impl.metricName())
    override val displayName: CustomMetricDisplayName =
      zio.aws.iot.model.primitives.CustomMetricDisplayName(impl.displayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest
  ): zio.aws.iot.model.UpdateCustomMetricRequest.ReadOnly = new Wrapper(impl)
}
