package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DimensionStringValue, DimensionName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDimensionRequest(
    name: DimensionName,
    stringValues: Iterable[DimensionStringValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDimensionRequest = {
    import UpdateDimensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDimensionRequest
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .stringValues(stringValues.map { item =>
        DimensionStringValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDimensionRequest.ReadOnly =
    zio.aws.iot.model.UpdateDimensionRequest.wrap(buildAwsValue())
}
object UpdateDimensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDimensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDimensionRequest =
      zio.aws.iot.model.UpdateDimensionRequest(name, stringValues)
    def name: DimensionName
    def stringValues: List[DimensionStringValue]
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
    def getStringValues: ZIO[Any, Nothing, List[DimensionStringValue]] =
      ZIO.succeed(stringValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDimensionRequest
  ) extends zio.aws.iot.model.UpdateDimensionRequest.ReadOnly {
    override val name: DimensionName =
      zio.aws.iot.model.primitives.DimensionName(impl.name())
    override val stringValues: List[DimensionStringValue] = impl
      .stringValues()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.DimensionStringValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDimensionRequest
  ): zio.aws.iot.model.UpdateDimensionRequest.ReadOnly = new Wrapper(impl)
}
