package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NamespaceId, JobDescription, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateJobRequest(
    jobId: JobId,
    description: Optional[JobDescription] = Optional.Absent,
    presignedUrlConfig: Optional[zio.aws.iot.model.PresignedUrlConfig] =
      Optional.Absent,
    jobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = Optional.Absent,
    abortConfig: Optional[zio.aws.iot.model.AbortConfig] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent,
    jobExecutionsRetryConfig: Optional[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateJobRequest = {
    import UpdateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateJobRequest.ReadOnly =
    zio.aws.iot.model.UpdateJobRequest.wrap(buildAwsValue())
}
object UpdateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateJobRequest =
      zio.aws.iot.model.UpdateJobRequest(
        jobId,
        description.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        namespaceId.map(value => value),
        jobExecutionsRetryConfig.map(value => value.asEditable)
      )
    def jobId: JobId
    def description: Optional[JobDescription]
    def presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def namespaceId: Optional[NamespaceId]
    def jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ) extends zio.aws.iot.model.UpdateJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlConfig())
        .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRolloutConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRetryConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ): zio.aws.iot.model.UpdateJobRequest.ReadOnly = new Wrapper(impl)
}
