package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{MitigationActionId, MitigationActionArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMitigationActionResponse(
    actionArn: Optional[MitigationActionArn] = Optional.Absent,
    actionId: Optional[MitigationActionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse = {
    import UpdateMitigationActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
      .builder()
      .optionallyWith(
        actionArn.map(value =>
          MitigationActionArn.unwrap(value): java.lang.String
        )
      )(_.actionArn)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly =
    zio.aws.iot.model.UpdateMitigationActionResponse.wrap(buildAwsValue())
}
object UpdateMitigationActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateMitigationActionResponse =
      zio.aws.iot.model.UpdateMitigationActionResponse(
        actionArn.map(value => value),
        actionId.map(value => value)
      )
    def actionArn: Optional[MitigationActionArn]
    def actionId: Optional[MitigationActionId]
    def getActionArn: ZIO[Any, AwsError, MitigationActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ) extends zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly {
    override val actionArn: Optional[MitigationActionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionArn())
        .map(value => zio.aws.iot.model.primitives.MitigationActionArn(value))
    override val actionId: Optional[MitigationActionId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse
  ): zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
