package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleArn,
  TemplateName,
  TemplateDescription,
  TemplateVersionId,
  Enabled,
  RemoveHook
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateProvisioningTemplateRequest(
    templateName: TemplateName,
    description: Optional[TemplateDescription] = Optional.Absent,
    enabled: Optional[Enabled] = Optional.Absent,
    defaultVersionId: Optional[TemplateVersionId] = Optional.Absent,
    provisioningRoleArn: Optional[RoleArn] = Optional.Absent,
    preProvisioningHook: Optional[zio.aws.iot.model.ProvisioningHook] =
      Optional.Absent,
    removePreProvisioningHook: Optional[RemoveHook] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest = {
    import UpdateProvisioningTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        defaultVersionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.defaultVersionId)
      .optionallyWith(
        provisioningRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.provisioningRoleArn)
      .optionallyWith(preProvisioningHook.map(value => value.buildAwsValue()))(
        _.preProvisioningHook
      )
      .optionallyWith(
        removePreProvisioningHook.map(value =>
          RemoveHook.unwrap(value): java.lang.Boolean
        )
      )(_.removePreProvisioningHook)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateProvisioningTemplateRequest.ReadOnly =
    zio.aws.iot.model.UpdateProvisioningTemplateRequest.wrap(buildAwsValue())
}
object UpdateProvisioningTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateProvisioningTemplateRequest =
      zio.aws.iot.model.UpdateProvisioningTemplateRequest(
        templateName,
        description.map(value => value),
        enabled.map(value => value),
        defaultVersionId.map(value => value),
        provisioningRoleArn.map(value => value),
        preProvisioningHook.map(value => value.asEditable),
        removePreProvisioningHook.map(value => value)
      )
    def templateName: TemplateName
    def description: Optional[TemplateDescription]
    def enabled: Optional[Enabled]
    def defaultVersionId: Optional[TemplateVersionId]
    def provisioningRoleArn: Optional[RoleArn]
    def preProvisioningHook
        : Optional[zio.aws.iot.model.ProvisioningHook.ReadOnly]
    def removePreProvisioningHook: Optional[RemoveHook]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDefaultVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getProvisioningRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("provisioningRoleArn", provisioningRoleArn)
    def getPreProvisioningHook
        : ZIO[Any, AwsError, zio.aws.iot.model.ProvisioningHook.ReadOnly] =
      AwsError.unwrapOptionField("preProvisioningHook", preProvisioningHook)
    def getRemovePreProvisioningHook: ZIO[Any, AwsError, RemoveHook] = AwsError
      .unwrapOptionField("removePreProvisioningHook", removePreProvisioningHook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest
  ) extends zio.aws.iot.model.UpdateProvisioningTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val description: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.TemplateDescription(value))
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
    override val defaultVersionId: Optional[TemplateVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val provisioningRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningRoleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val preProvisioningHook
        : Optional[zio.aws.iot.model.ProvisioningHook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preProvisioningHook())
        .map(value => zio.aws.iot.model.ProvisioningHook.wrap(value))
    override val removePreProvisioningHook: Optional[RemoveHook] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removePreProvisioningHook())
        .map(value => zio.aws.iot.model.primitives.RemoveHook(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest
  ): zio.aws.iot.model.UpdateProvisioningTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
