package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ScheduledAuditArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateScheduledAuditResponse(
    scheduledAuditArn: Optional[ScheduledAuditArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse = {
    import UpdateScheduledAuditResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse
      .builder()
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly =
    zio.aws.iot.model.UpdateScheduledAuditResponse.wrap(buildAwsValue())
}
object UpdateScheduledAuditResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateScheduledAuditResponse =
      zio.aws.iot.model
        .UpdateScheduledAuditResponse(scheduledAuditArn.map(value => value))
    def scheduledAuditArn: Optional[ScheduledAuditArn]
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse
  ) extends zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly {
    override val scheduledAuditArn: Optional[ScheduledAuditArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditArn())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse
  ): zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly = new Wrapper(impl)
}
