package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, StreamDescription, StreamId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamRequest(
    streamId: StreamId,
    description: Optional[StreamDescription] = Optional.Absent,
    files: Optional[Iterable[zio.aws.iot.model.StreamFile]] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateStreamRequest = {
    import UpdateStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateStreamRequest
      .builder()
      .streamId(StreamId.unwrap(streamId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        files.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.files)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateStreamRequest.ReadOnly =
    zio.aws.iot.model.UpdateStreamRequest.wrap(buildAwsValue())
}
object UpdateStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateStreamRequest =
      zio.aws.iot.model.UpdateStreamRequest(
        streamId,
        description.map(value => value),
        files.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value)
      )
    def streamId: StreamId
    def description: Optional[StreamDescription]
    def files: Optional[List[zio.aws.iot.model.StreamFile.ReadOnly]]
    def roleArn: Optional[RoleArn]
    def getStreamId: ZIO[Any, Nothing, StreamId] = ZIO.succeed(streamId)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFiles
        : ZIO[Any, AwsError, List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      AwsError.unwrapOptionField("files", files)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamRequest
  ) extends zio.aws.iot.model.UpdateStreamRequest.ReadOnly {
    override val streamId: StreamId =
      zio.aws.iot.model.primitives.StreamId(impl.streamId())
    override val description: Optional[StreamDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val files: Optional[List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.StreamFile.wrap(item)
          }.toList
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamRequest
  ): zio.aws.iot.model.UpdateStreamRequest.ReadOnly = new Wrapper(impl)
}
