package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  StreamVersion,
  StreamDescription,
  StreamArn,
  StreamId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateStreamResponse(
    streamId: Optional[StreamId] = Optional.Absent,
    streamArn: Optional[StreamArn] = Optional.Absent,
    description: Optional[StreamDescription] = Optional.Absent,
    streamVersion: Optional[StreamVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateStreamResponse = {
    import UpdateStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateStreamResponse
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        streamVersion.map(value => StreamVersion.unwrap(value): Integer)
      )(_.streamVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateStreamResponse.ReadOnly =
    zio.aws.iot.model.UpdateStreamResponse.wrap(buildAwsValue())
}
object UpdateStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateStreamResponse =
      zio.aws.iot.model.UpdateStreamResponse(
        streamId.map(value => value),
        streamArn.map(value => value),
        description.map(value => value),
        streamVersion.map(value => value)
      )
    def streamId: Optional[StreamId]
    def streamArn: Optional[StreamArn]
    def description: Optional[StreamDescription]
    def streamVersion: Optional[StreamVersion]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStreamVersion: ZIO[Any, AwsError, StreamVersion] =
      AwsError.unwrapOptionField("streamVersion", streamVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ) extends zio.aws.iot.model.UpdateStreamResponse.ReadOnly {
    override val streamId: Optional[StreamId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.iot.model.primitives.StreamArn(value))
    override val description: Optional[StreamDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val streamVersion: Optional[StreamVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.streamVersion())
      .map(value => zio.aws.iot.model.primitives.StreamVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ): zio.aws.iot.model.UpdateStreamResponse.ReadOnly = new Wrapper(impl)
}
