package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateThingGroupRequest(
    thingGroupName: ThingGroupName,
    thingGroupProperties: zio.aws.iot.model.ThingGroupProperties,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest = {
    import UpdateThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .thingGroupProperties(thingGroupProperties.buildAwsValue())
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateThingGroupRequest.ReadOnly =
    zio.aws.iot.model.UpdateThingGroupRequest.wrap(buildAwsValue())
}
object UpdateThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateThingGroupRequest =
      zio.aws.iot.model.UpdateThingGroupRequest(
        thingGroupName,
        thingGroupProperties.asEditable,
        expectedVersion.map(value => value)
      )
    def thingGroupName: ThingGroupName
    def thingGroupProperties: zio.aws.iot.model.ThingGroupProperties.ReadOnly
    def expectedVersion: Optional[OptionalVersion]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getThingGroupProperties
        : ZIO[Any, Nothing, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      ZIO.succeed(thingGroupProperties)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest
  ) extends zio.aws.iot.model.UpdateThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val thingGroupProperties
        : zio.aws.iot.model.ThingGroupProperties.ReadOnly =
      zio.aws.iot.model.ThingGroupProperties.wrap(impl.thingGroupProperties())
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest
  ): zio.aws.iot.model.UpdateThingGroupRequest.ReadOnly = new Wrapper(impl)
}
