package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Version
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateThingGroupResponse(
    version: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse = {
    import UpdateThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly =
    zio.aws.iot.model.UpdateThingGroupResponse.wrap(buildAwsValue())
}
object UpdateThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateThingGroupResponse =
      zio.aws.iot.model.UpdateThingGroupResponse(version.map(value => value))
    def version: Optional[Version]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse
  ) extends zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly {
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse
  ): zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly = new Wrapper(impl)
}
