package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ValidateSecurityProfileBehaviorsRequest(
    behaviors: Iterable[zio.aws.iot.model.Behavior]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest = {
    import ValidateSecurityProfileBehaviorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest
      .builder()
      .behaviors(behaviors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest.ReadOnly =
    zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest
      .wrap(buildAwsValue())
}
object ValidateSecurityProfileBehaviorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest =
      zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest(behaviors.map {
        item =>
          item.asEditable
      })
    def behaviors: List[zio.aws.iot.model.Behavior.ReadOnly]
    def getBehaviors
        : ZIO[Any, Nothing, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      ZIO.succeed(behaviors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest
  ) extends zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest.ReadOnly {
    override val behaviors: List[zio.aws.iot.model.Behavior.ReadOnly] = impl
      .behaviors()
      .asScala
      .map { item =>
        zio.aws.iot.model.Behavior.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest
  ): zio.aws.iot.model.ValidateSecurityProfileBehaviorsRequest.ReadOnly =
    new Wrapper(impl)
}
