package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Valid
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateSecurityProfileBehaviorsResponse(
    valid: Optional[Valid] = Optional.Absent,
    validationErrors: Optional[Iterable[zio.aws.iot.model.ValidationError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse = {
    import ValidateSecurityProfileBehaviorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse
      .builder()
      .optionallyWith(
        valid.map(value => Valid.unwrap(value): java.lang.Boolean)
      )(_.valid)
      .optionallyWith(
        validationErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly =
    zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse
      .wrap(buildAwsValue())
}
object ValidateSecurityProfileBehaviorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse =
      zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse(
        valid.map(value => value),
        validationErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def valid: Optional[Valid]
    def validationErrors
        : Optional[List[zio.aws.iot.model.ValidationError.ReadOnly]]
    def getValid: ZIO[Any, AwsError, Valid] =
      AwsError.unwrapOptionField("valid", valid)
    def getValidationErrors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ValidationError.ReadOnly]] =
      AwsError.unwrapOptionField("validationErrors", validationErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse
  ) extends zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly {
    override val valid: Optional[Valid] = zio.aws.core.internal
      .optionalFromNullable(impl.valid())
      .map(value => zio.aws.iot.model.primitives.Valid(value))
    override val validationErrors
        : Optional[List[zio.aws.iot.model.ValidationError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ValidationError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse
  ): zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly =
    new Wrapper(impl)
}
