package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ErrorMessage
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidationError(
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ValidationError = {
    import ValidationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ValidationError
      .builder()
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ValidationError.ReadOnly =
    zio.aws.iot.model.ValidationError.wrap(buildAwsValue())
}
object ValidationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ValidationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ValidationError =
      zio.aws.iot.model.ValidationError(errorMessage.map(value => value))
    def errorMessage: Optional[ErrorMessage]
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ValidationError
  ) extends zio.aws.iot.model.ValidationError.ReadOnly {
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ValidationError
  ): zio.aws.iot.model.ValidationError.ReadOnly = new Wrapper(impl)
}
