package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ViolationEventOccurrenceRange(
    startTime: Timestamp,
    endTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange = {
    import ViolationEventOccurrenceRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly =
    zio.aws.iot.model.ViolationEventOccurrenceRange.wrap(buildAwsValue())
}
object ViolationEventOccurrenceRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ViolationEventOccurrenceRange =
      zio.aws.iot.model.ViolationEventOccurrenceRange(startTime, endTime)
    def startTime: Timestamp
    def endTime: Timestamp
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange
  ) extends zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.iot.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ViolationEventOccurrenceRange
  ): zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly = new Wrapper(
    impl
  )
}
