package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ViolationEventType {
  def unwrap: software.amazon.awssdk.services.iot.model.ViolationEventType
}
object ViolationEventType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ViolationEventType
  ): zio.aws.iot.model.ViolationEventType = value match {
    case software.amazon.awssdk.services.iot.model.ViolationEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ViolationEventType.IN_ALARM =>
      val r = `in-alarm`
      r
    case software.amazon.awssdk.services.iot.model.ViolationEventType.ALARM_CLEARED =>
      val r = `alarm-cleared`
      r
    case software.amazon.awssdk.services.iot.model.ViolationEventType.ALARM_INVALIDATED =>
      val r = `alarm-invalidated`
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ViolationEventType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ViolationEventType =
      software.amazon.awssdk.services.iot.model.ViolationEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object `in-alarm` extends zio.aws.iot.model.ViolationEventType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ViolationEventType =
      software.amazon.awssdk.services.iot.model.ViolationEventType.IN_ALARM
  }
  case object `alarm-cleared` extends zio.aws.iot.model.ViolationEventType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ViolationEventType =
      software.amazon.awssdk.services.iot.model.ViolationEventType.ALARM_CLEARED
  }
  case object `alarm-invalidated` extends zio.aws.iot.model.ViolationEventType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ViolationEventType =
      software.amazon.awssdk.services.iot.model.ViolationEventType.ALARM_INVALIDATED
  }
}
