package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AwsArn, VpcId, SecurityGroupId, SubnetId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcDestinationProperties(
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    roleArn: Optional[AwsArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.VpcDestinationProperties = {
    import VpcDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.VpcDestinationProperties
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.VpcDestinationProperties.ReadOnly =
    zio.aws.iot.model.VpcDestinationProperties.wrap(buildAwsValue())
}
object VpcDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.VpcDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.VpcDestinationProperties =
      zio.aws.iot.model.VpcDestinationProperties(
        subnetIds.map(value => value),
        securityGroups.map(value => value),
        vpcId.map(value => value),
        roleArn.map(value => value)
      )
    def subnetIds: Optional[List[SubnetId]]
    def securityGroups: Optional[List[SecurityGroupId]]
    def vpcId: Optional[VpcId]
    def roleArn: Optional[AwsArn]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationProperties
  ) extends zio.aws.iot.model.VpcDestinationProperties.ReadOnly {
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.iot.model.primitives.VpcId(value))
    override val roleArn: Optional[AwsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationProperties
  ): zio.aws.iot.model.VpcDestinationProperties.ReadOnly = new Wrapper(impl)
}
