package zio.aws.iot
import zio.aws.iot.model.PutVerificationStateOnViolationResponse.ReadOnly
import zio.aws.iot.model.{
  ListJobTemplatesRequest,
  GetBehaviorModelTrainingSummariesRequest,
  GetPolicyVersionRequest,
  SearchIndexRequest,
  CreateJobTemplateRequest,
  DescribeRoleAliasRequest,
  DeleteJobExecutionRequest,
  DeleteAuditSuppressionRequest,
  DescribeStreamRequest,
  AttachSecurityProfileRequest,
  GetOtaUpdateRequest,
  CreateThingTypeRequest,
  ListScheduledAuditsRequest,
  UpdateTopicRuleDestinationRequest,
  UpdateDimensionRequest,
  DeleteRegistrationCodeRequest,
  ListStreamsRequest,
  DescribeAuditFindingRequest,
  GetLoggingOptionsRequest,
  UpdateRoleAliasRequest,
  ListAuditMitigationActionsTasksRequest,
  RemoveThingFromBillingGroupRequest,
  DeleteV2LoggingLevelRequest,
  CancelDetectMitigationActionsTaskRequest,
  CreateProvisioningTemplateRequest,
  CreateMitigationActionRequest,
  DeleteMitigationActionRequest,
  StartThingRegistrationTaskRequest,
  DescribeManagedJobTemplateRequest,
  DeleteAccountAuditConfigurationRequest,
  CreateDimensionRequest,
  ListIndicesRequest,
  DescribeEventConfigurationsRequest,
  DeleteDimensionRequest,
  AddThingToThingGroupRequest,
  ListPrincipalThingsRequest,
  DeleteDynamicThingGroupRequest,
  SetLoggingOptionsRequest,
  UpdateMitigationActionRequest,
  ListBillingGroupsRequest,
  DescribeThingTypeRequest,
  DescribeThingRequest,
  CancelCertificateTransferRequest,
  CancelJobRequest,
  ListCertificatesByCaRequest,
  ListPoliciesRequest,
  DescribeDefaultAuthorizerRequest,
  RejectCertificateTransferRequest,
  DescribeJobTemplateRequest,
  DescribeDetectMitigationActionsTaskRequest,
  ListJobExecutionsForJobRequest,
  GetTopicRuleRequest,
  AttachThingPrincipalRequest,
  CreateAuthorizerRequest,
  ClearDefaultAuthorizerRequest,
  DeleteProvisioningTemplateVersionRequest,
  ListJobsRequest,
  ListOtaUpdatesRequest,
  DeleteFleetMetricRequest,
  DescribeProvisioningTemplateVersionRequest,
  ListAuditMitigationActionsExecutionsRequest,
  RegisterCertificateRequest,
  GetV2LoggingOptionsRequest,
  UpdateScheduledAuditRequest,
  ListAuditSuppressionsRequest,
  DescribeJobRequest,
  UpdateIndexingConfigurationRequest,
  CreateScheduledAuditRequest,
  ListTargetsForSecurityProfileRequest,
  DeleteThingGroupRequest,
  CreateCertificateFromCsrRequest,
  GetTopicRuleDestinationRequest,
  DeleteTopicRuleDestinationRequest,
  DescribeMitigationActionRequest,
  DescribeCustomMetricRequest,
  ListSecurityProfilesForTargetRequest,
  ListProvisioningTemplatesRequest,
  DeleteTopicRuleRequest,
  ListTagsForResourceRequest,
  DescribeAuditMitigationActionsTaskRequest,
  GetCardinalityRequest,
  CreateKeysAndCertificateRequest,
  CreateBillingGroupRequest,
  ListCustomMetricsRequest,
  ListFleetMetricsRequest,
  CreateDomainConfigurationRequest,
  ListTargetsForPolicyRequest,
  ReplaceTopicRuleRequest,
  AssociateTargetsWithJobRequest,
  DescribeAuditSuppressionRequest,
  UpdateStreamRequest,
  CreateProvisioningClaimRequest,
  SetV2LoggingOptionsRequest,
  UpdateCaCertificateRequest,
  StopThingRegistrationTaskRequest,
  ListThingRegistrationTaskReportsRequest,
  UpdateAuditSuppressionRequest,
  DeleteDomainConfigurationRequest,
  ValidateSecurityProfileBehaviorsRequest,
  UpdateAccountAuditConfigurationRequest,
  CreateStreamRequest,
  StartDetectMitigationActionsTaskRequest,
  DisableTopicRuleRequest,
  DeleteAuthorizerRequest,
  RegisterCaCertificateRequest,
  DeletePolicyVersionRequest,
  DescribeDimensionRequest,
  DeleteJobRequest,
  StartOnDemandAuditTaskRequest,
  UpdateBillingGroupRequest,
  DeleteProvisioningTemplateRequest,
  DeleteThingTypeRequest,
  ListMitigationActionsRequest,
  ListThingRegistrationTasksRequest,
  GetEffectivePoliciesRequest,
  CreateCustomMetricRequest,
  DescribeProvisioningTemplateRequest,
  ListRoleAliasesRequest,
  ListActiveViolationsRequest,
  DeleteCustomMetricRequest,
  RemoveThingFromThingGroupRequest,
  DeleteBillingGroupRequest,
  ListThingsRequest,
  DeleteJobTemplateRequest,
  CreateTopicRuleRequest,
  GetIndexingConfigurationRequest,
  SetDefaultPolicyVersionRequest,
  ListV2LoggingLevelsRequest,
  UpdateDomainConfigurationRequest,
  DeleteCaCertificateRequest,
  ListViolationEventsRequest,
  ListThingPrincipalsRequest,
  ListAuditTasksRequest,
  DescribeSecurityProfileRequest,
  DescribeCaCertificateRequest,
  GetJobDocumentRequest,
  DetachThingPrincipalRequest,
  CreateDynamicThingGroupRequest,
  DescribeFleetMetricRequest,
  ListDetectMitigationActionsExecutionsRequest,
  UpdateCertificateRequest,
  ListThingsInThingGroupRequest,
  DescribeAuthorizerRequest,
  RegisterCertificateWithoutCaRequest,
  UpdateCustomMetricRequest,
  DeleteStreamRequest,
  ListJobExecutionsForThingRequest,
  UpdateDynamicThingGroupRequest,
  DeleteThingRequest,
  EnableTopicRuleRequest,
  ListPolicyVersionsRequest,
  CreateTopicRuleDestinationRequest,
  CreateOtaUpdateRequest,
  RegisterThingRequest,
  GetPolicyRequest,
  ListDomainConfigurationsRequest,
  DeleteOtaUpdateRequest,
  ConfirmTopicRuleDestinationRequest,
  ListCaCertificatesRequest,
  UpdateSecurityProfileRequest,
  DetachPolicyRequest,
  CreateThingRequest,
  UntagResourceRequest,
  DescribeScheduledAuditRequest,
  CreatePolicyVersionRequest,
  AcceptCertificateTransferRequest,
  DetachSecurityProfileRequest,
  ListCertificatesRequest,
  ListTopicRuleDestinationsRequest,
  ListOutgoingCertificatesRequest,
  CreateJobRequest,
  DescribeJobExecutionRequest,
  ListThingGroupsRequest,
  DescribeEndpointRequest,
  ListProvisioningTemplateVersionsRequest,
  CreateRoleAliasRequest,
  GetPercentilesRequest,
  SetV2LoggingLevelRequest,
  UpdateJobRequest,
  DescribeBillingGroupRequest,
  DescribeAccountAuditConfigurationRequest,
  GetRegistrationCodeRequest,
  CancelJobExecutionRequest,
  CreateThingGroupRequest,
  UpdateThingRequest,
  DescribeDomainConfigurationRequest,
  GetStatisticsRequest,
  ListThingsInBillingGroupRequest,
  ListAuthorizersRequest,
  TestInvokeAuthorizerRequest,
  UpdateThingGroupsForThingRequest,
  ListThingGroupsForThingRequest,
  TransferCertificateRequest,
  ListSecurityProfilesRequest,
  AddThingToBillingGroupRequest,
  CreateSecurityProfileRequest,
  CancelAuditMitigationActionsTaskRequest,
  UpdateFleetMetricRequest,
  DescribeAuditTaskRequest,
  ListManagedJobTemplatesRequest,
  DeletePolicyRequest,
  StartAuditMitigationActionsTaskRequest,
  CreateProvisioningTemplateVersionRequest,
  DeleteScheduledAuditRequest,
  DeleteRoleAliasRequest,
  ListAttachedPoliciesRequest,
  DescribeCertificateRequest,
  UpdateThingGroupRequest,
  UpdateProvisioningTemplateRequest,
  ListAuditFindingsRequest,
  ListThingTypesRequest,
  UpdateEventConfigurationsRequest,
  DeleteSecurityProfileRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  CancelAuditTaskRequest,
  UpdateAuthorizerRequest,
  AttachPolicyRequest,
  DescribeThingGroupRequest,
  TestAuthorizationRequest,
  CreateAuditSuppressionRequest,
  CreatePolicyRequest,
  PutVerificationStateOnViolationRequest,
  ListDetectMitigationActionsTasksRequest,
  ListDimensionsRequest,
  GetBucketsAggregationRequest,
  ListTopicRulesRequest,
  DescribeIndexRequest,
  DescribeThingRegistrationTaskRequest,
  SetDefaultAuthorizerRequest,
  DeprecateThingTypeRequest,
  CreateFleetMetricRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.iot.IotAsyncClient
import zio.aws.iot.model.primitives.{
  MetricName,
  IndexName,
  RoleAlias,
  ThingName,
  PrincipalArn,
  S3FileUrl,
  DimensionName,
  PolicyTarget,
  TaskId
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object IotMock extends Mock[Iot] {
  object DeleteCustomMetric
      extends Effect[
        DeleteCustomMetricRequest,
        AwsError,
        zio.aws.iot.model.DeleteCustomMetricResponse.ReadOnly
      ]
  object CreateProvisioningTemplateVersion
      extends Effect[
        CreateProvisioningTemplateVersionRequest,
        AwsError,
        zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly
      ]
  object RegisterThing
      extends Effect[
        RegisterThingRequest,
        AwsError,
        zio.aws.iot.model.RegisterThingResponse.ReadOnly
      ]
  object ListProvisioningTemplateVersions
      extends Stream[
        ListProvisioningTemplateVersionsRequest,
        AwsError,
        zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
      ]
  object ListProvisioningTemplateVersionsPaginated
      extends Effect[
        ListProvisioningTemplateVersionsRequest,
        AwsError,
        zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly
      ]
  object UpdateAuditSuppression
      extends Effect[
        UpdateAuditSuppressionRequest,
        AwsError,
        zio.aws.iot.model.UpdateAuditSuppressionResponse.ReadOnly
      ]
  object ListTargetsForSecurityProfile
      extends Stream[
        ListTargetsForSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.SecurityProfileTarget.ReadOnly
      ]
  object ListTargetsForSecurityProfilePaginated
      extends Effect[
        ListTargetsForSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly
      ]
  object CreateDynamicThingGroup
      extends Effect[
        CreateDynamicThingGroupRequest,
        AwsError,
        zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly
      ]
  object ListStreams
      extends Stream[
        ListStreamsRequest,
        AwsError,
        zio.aws.iot.model.StreamSummary.ReadOnly
      ]
  object ListStreamsPaginated
      extends Effect[
        ListStreamsRequest,
        AwsError,
        zio.aws.iot.model.ListStreamsResponse.ReadOnly
      ]
  object CreateTopicRuleDestination
      extends Effect[
        CreateTopicRuleDestinationRequest,
        AwsError,
        zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly
      ]
  object CreateScheduledAudit
      extends Effect[
        CreateScheduledAuditRequest,
        AwsError,
        zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly
      ]
  object DescribeJob
      extends Effect[
        DescribeJobRequest,
        AwsError,
        zio.aws.iot.model.DescribeJobResponse.ReadOnly
      ]
  object CreateOTAUpdate
      extends Effect[
        CreateOtaUpdateRequest,
        AwsError,
        zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly
      ]
  object DeleteDomainConfiguration
      extends Effect[
        DeleteDomainConfigurationRequest,
        AwsError,
        zio.aws.iot.model.DeleteDomainConfigurationResponse.ReadOnly
      ]
  object SetV2LoggingLevel
      extends Effect[SetV2LoggingLevelRequest, AwsError, Unit]
  object DeleteJobExecution
      extends Effect[DeleteJobExecutionRequest, AwsError, Unit]
  object TestInvokeAuthorizer
      extends Effect[
        TestInvokeAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly
      ]
  object UpdateCACertificate
      extends Effect[UpdateCaCertificateRequest, AwsError, Unit]
  object DeleteDimension
      extends Effect[
        DeleteDimensionRequest,
        AwsError,
        zio.aws.iot.model.DeleteDimensionResponse.ReadOnly
      ]
  object ListIndices extends Stream[ListIndicesRequest, AwsError, IndexName]
  object ListIndicesPaginated
      extends Effect[
        ListIndicesRequest,
        AwsError,
        zio.aws.iot.model.ListIndicesResponse.ReadOnly
      ]
  object RemoveThingFromThingGroup
      extends Effect[
        RemoveThingFromThingGroupRequest,
        AwsError,
        zio.aws.iot.model.RemoveThingFromThingGroupResponse.ReadOnly
      ]
  object DescribeAuthorizer
      extends Effect[
        DescribeAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly
      ]
  object UpdateIndexingConfiguration
      extends Effect[
        UpdateIndexingConfigurationRequest,
        AwsError,
        zio.aws.iot.model.UpdateIndexingConfigurationResponse.ReadOnly
      ]
  object CancelJobExecution
      extends Effect[CancelJobExecutionRequest, AwsError, Unit]
  object DetachThingPrincipal
      extends Effect[
        DetachThingPrincipalRequest,
        AwsError,
        zio.aws.iot.model.DetachThingPrincipalResponse.ReadOnly
      ]
  object DeleteBillingGroup
      extends Effect[
        DeleteBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.DeleteBillingGroupResponse.ReadOnly
      ]
  object CreateKeysAndCertificate
      extends Effect[
        CreateKeysAndCertificateRequest,
        AwsError,
        zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly
      ]
  object UpdateScheduledAudit
      extends Effect[
        UpdateScheduledAuditRequest,
        AwsError,
        zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly
      ]
  object DeleteThingGroup
      extends Effect[
        DeleteThingGroupRequest,
        AwsError,
        zio.aws.iot.model.DeleteThingGroupResponse.ReadOnly
      ]
  object ListJobTemplates
      extends Stream[
        ListJobTemplatesRequest,
        AwsError,
        zio.aws.iot.model.JobTemplateSummary.ReadOnly
      ]
  object ListJobTemplatesPaginated
      extends Effect[
        ListJobTemplatesRequest,
        AwsError,
        zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly
      ]
  object DescribeProvisioningTemplate
      extends Effect[
        DescribeProvisioningTemplateRequest,
        AwsError,
        zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly
      ]
  object ListSecurityProfilesForTarget
      extends Stream[
        ListSecurityProfilesForTargetRequest,
        AwsError,
        zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
      ]
  object ListSecurityProfilesForTargetPaginated
      extends Effect[
        ListSecurityProfilesForTargetRequest,
        AwsError,
        zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly
      ]
  object CancelDetectMitigationActionsTask
      extends Effect[
        CancelDetectMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.ReadOnly
      ]
  object GetIndexingConfiguration
      extends Effect[
        GetIndexingConfigurationRequest,
        AwsError,
        zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly
      ]
  object StopThingRegistrationTask
      extends Effect[
        StopThingRegistrationTaskRequest,
        AwsError,
        zio.aws.iot.model.StopThingRegistrationTaskResponse.ReadOnly
      ]
  object CreateSecurityProfile
      extends Effect[
        CreateSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly
      ]
  object UpdateDimension
      extends Effect[
        UpdateDimensionRequest,
        AwsError,
        zio.aws.iot.model.UpdateDimensionResponse.ReadOnly
      ]
  object UpdateCustomMetric
      extends Effect[
        UpdateCustomMetricRequest,
        AwsError,
        zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly
      ]
  object DescribeThingRegistrationTask
      extends Effect[
        DescribeThingRegistrationTaskRequest,
        AwsError,
        zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly
      ]
  object ListCACertificates
      extends Stream[
        ListCaCertificatesRequest,
        AwsError,
        zio.aws.iot.model.CACertificate.ReadOnly
      ]
  object ListCACertificatesPaginated
      extends Effect[
        ListCaCertificatesRequest,
        AwsError,
        zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly
      ]
  object DeleteProvisioningTemplateVersion
      extends Effect[
        DeleteProvisioningTemplateVersionRequest,
        AwsError,
        zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.ReadOnly
      ]
  object GetCardinality
      extends Effect[
        GetCardinalityRequest,
        AwsError,
        zio.aws.iot.model.GetCardinalityResponse.ReadOnly
      ]
  object ListDomainConfigurations
      extends Stream[
        ListDomainConfigurationsRequest,
        AwsError,
        zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
      ]
  object ListDomainConfigurationsPaginated
      extends Effect[
        ListDomainConfigurationsRequest,
        AwsError,
        zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly
      ]
  object DescribeAccountAuditConfiguration
      extends Effect[
        DescribeAccountAuditConfigurationRequest,
        AwsError,
        zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly
      ]
  object PutVerificationStateOnViolation
      extends Effect[PutVerificationStateOnViolationRequest, AwsError, ReadOnly]
  object ListPrincipalThings
      extends Stream[ListPrincipalThingsRequest, AwsError, ThingName]
  object ListPrincipalThingsPaginated
      extends Effect[
        ListPrincipalThingsRequest,
        AwsError,
        zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly
      ]
  object GetBehaviorModelTrainingSummaries
      extends Stream[
        GetBehaviorModelTrainingSummariesRequest,
        AwsError,
        zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
      ]
  object GetBehaviorModelTrainingSummariesPaginated
      extends Effect[
        GetBehaviorModelTrainingSummariesRequest,
        AwsError,
        zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly
      ]
  object DescribeScheduledAudit
      extends Effect[
        DescribeScheduledAuditRequest,
        AwsError,
        zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly
      ]
  object UpdateThingGroupsForThing
      extends Effect[
        UpdateThingGroupsForThingRequest,
        AwsError,
        zio.aws.iot.model.UpdateThingGroupsForThingResponse.ReadOnly
      ]
  object UpdateThing
      extends Effect[
        UpdateThingRequest,
        AwsError,
        zio.aws.iot.model.UpdateThingResponse.ReadOnly
      ]
  object DescribeThing
      extends Effect[
        DescribeThingRequest,
        AwsError,
        zio.aws.iot.model.DescribeThingResponse.ReadOnly
      ]
  object CreateProvisioningClaim
      extends Effect[
        CreateProvisioningClaimRequest,
        AwsError,
        zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly
      ]
  object GetPercentiles
      extends Effect[
        GetPercentilesRequest,
        AwsError,
        zio.aws.iot.model.GetPercentilesResponse.ReadOnly
      ]
  object DeleteMitigationAction
      extends Effect[
        DeleteMitigationActionRequest,
        AwsError,
        zio.aws.iot.model.DeleteMitigationActionResponse.ReadOnly
      ]
  object DescribeJobExecution
      extends Effect[
        DescribeJobExecutionRequest,
        AwsError,
        zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly
      ]
  object UpdateStream
      extends Effect[
        UpdateStreamRequest,
        AwsError,
        zio.aws.iot.model.UpdateStreamResponse.ReadOnly
      ]
  object DeleteAuditSuppression
      extends Effect[
        DeleteAuditSuppressionRequest,
        AwsError,
        zio.aws.iot.model.DeleteAuditSuppressionResponse.ReadOnly
      ]
  object DeleteJobTemplate
      extends Effect[DeleteJobTemplateRequest, AwsError, Unit]
  object GetJobDocument
      extends Effect[
        GetJobDocumentRequest,
        AwsError,
        zio.aws.iot.model.GetJobDocumentResponse.ReadOnly
      ]
  object GetRegistrationCode
      extends Effect[
        GetRegistrationCodeRequest,
        AwsError,
        zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly
      ]
  object UpdateThingGroup
      extends Effect[
        UpdateThingGroupRequest,
        AwsError,
        zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly
      ]
  object ListJobExecutionsForJob
      extends Stream[
        ListJobExecutionsForJobRequest,
        AwsError,
        zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly
      ]
  object ListJobExecutionsForJobPaginated
      extends Effect[
        ListJobExecutionsForJobRequest,
        AwsError,
        zio.aws.iot.model.ListJobExecutionsForJobResponse.ReadOnly
      ]
  object ListAuditSuppressions
      extends Stream[
        ListAuditSuppressionsRequest,
        AwsError,
        zio.aws.iot.model.AuditSuppression.ReadOnly
      ]
  object ListAuditSuppressionsPaginated
      extends Effect[
        ListAuditSuppressionsRequest,
        AwsError,
        zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly
      ]
  object DescribeManagedJobTemplate
      extends Effect[
        DescribeManagedJobTemplateRequest,
        AwsError,
        zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly
      ]
  object CreateBillingGroup
      extends Effect[
        CreateBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly
      ]
  object ListTargetsForPolicy
      extends Stream[ListTargetsForPolicyRequest, AwsError, PolicyTarget]
  object ListTargetsForPolicyPaginated
      extends Effect[
        ListTargetsForPolicyRequest,
        AwsError,
        zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly
      ]
  object DescribeDomainConfiguration
      extends Effect[
        DescribeDomainConfigurationRequest,
        AwsError,
        zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly
      ]
  object DescribeCACertificate
      extends Effect[
        DescribeCaCertificateRequest,
        AwsError,
        zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly
      ]
  object UpdateDomainConfiguration
      extends Effect[
        UpdateDomainConfigurationRequest,
        AwsError,
        zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly
      ]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.iot.model.CreateJobResponse.ReadOnly
      ]
  object SetLoggingOptions
      extends Effect[SetLoggingOptionsRequest, AwsError, Unit]
  object ListAttachedPolicies
      extends Stream[
        ListAttachedPoliciesRequest,
        AwsError,
        zio.aws.iot.model.Policy.ReadOnly
      ]
  object ListAttachedPoliciesPaginated
      extends Effect[
        ListAttachedPoliciesRequest,
        AwsError,
        zio.aws.iot.model.ListAttachedPoliciesResponse.ReadOnly
      ]
  object DetachPolicy extends Effect[DetachPolicyRequest, AwsError, Unit]
  object DescribeIndex
      extends Effect[
        DescribeIndexRequest,
        AwsError,
        zio.aws.iot.model.DescribeIndexResponse.ReadOnly
      ]
  object CancelAuditMitigationActionsTask
      extends Effect[
        CancelAuditMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.ReadOnly
      ]
  object AttachThingPrincipal
      extends Effect[
        AttachThingPrincipalRequest,
        AwsError,
        zio.aws.iot.model.AttachThingPrincipalResponse.ReadOnly
      ]
  object DescribeMitigationAction
      extends Effect[
        DescribeMitigationActionRequest,
        AwsError,
        zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly
      ]
  object CreateProvisioningTemplate
      extends Effect[
        CreateProvisioningTemplateRequest,
        AwsError,
        zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly
      ]
  object ListThingsInBillingGroup
      extends Stream[ListThingsInBillingGroupRequest, AwsError, ThingName]
  object ListThingsInBillingGroupPaginated
      extends Effect[
        ListThingsInBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.ListThingsInBillingGroupResponse.ReadOnly
      ]
  object CancelJob
      extends Effect[
        CancelJobRequest,
        AwsError,
        zio.aws.iot.model.CancelJobResponse.ReadOnly
      ]
  object ListViolationEvents
      extends Stream[
        ListViolationEventsRequest,
        AwsError,
        zio.aws.iot.model.ViolationEvent.ReadOnly
      ]
  object ListViolationEventsPaginated
      extends Effect[
        ListViolationEventsRequest,
        AwsError,
        zio.aws.iot.model.ListViolationEventsResponse.ReadOnly
      ]
  object DescribeThingGroup
      extends Effect[
        DescribeThingGroupRequest,
        AwsError,
        zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly
      ]
  object ListTopicRules
      extends Stream[
        ListTopicRulesRequest,
        AwsError,
        zio.aws.iot.model.TopicRuleListItem.ReadOnly
      ]
  object ListTopicRulesPaginated
      extends Effect[
        ListTopicRulesRequest,
        AwsError,
        zio.aws.iot.model.ListTopicRulesResponse.ReadOnly
      ]
  object ListPolicyVersions
      extends Effect[
        ListPolicyVersionsRequest,
        AwsError,
        zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly
      ]
  object UpdateAuthorizer
      extends Effect[
        UpdateAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly
      ]
  object CreateDomainConfiguration
      extends Effect[
        CreateDomainConfigurationRequest,
        AwsError,
        zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly
      ]
  object GetOTAUpdate
      extends Effect[
        GetOtaUpdateRequest,
        AwsError,
        zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly
      ]
  object RegisterCertificateWithoutCA
      extends Effect[
        RegisterCertificateWithoutCaRequest,
        AwsError,
        zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly
      ]
  object RejectCertificateTransfer
      extends Effect[RejectCertificateTransferRequest, AwsError, Unit]
  object DescribeAuditFinding
      extends Effect[
        DescribeAuditFindingRequest,
        AwsError,
        zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly
      ]
  object StartOnDemandAuditTask
      extends Effect[
        StartOnDemandAuditTaskRequest,
        AwsError,
        zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly
      ]
  object DeleteSecurityProfile
      extends Effect[
        DeleteSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.DeleteSecurityProfileResponse.ReadOnly
      ]
  object ListAuditMitigationActionsExecutions
      extends Stream[
        ListAuditMitigationActionsExecutionsRequest,
        AwsError,
        zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
      ]
  object ListAuditMitigationActionsExecutionsPaginated
      extends Effect[
        ListAuditMitigationActionsExecutionsRequest,
        AwsError,
        zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly
      ]
  object GetTopicRuleDestination
      extends Effect[
        GetTopicRuleDestinationRequest,
        AwsError,
        zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly
      ]
  object ListThingGroups
      extends Stream[
        ListThingGroupsRequest,
        AwsError,
        zio.aws.iot.model.GroupNameAndArn.ReadOnly
      ]
  object ListThingGroupsPaginated
      extends Effect[
        ListThingGroupsRequest,
        AwsError,
        zio.aws.iot.model.ListThingGroupsResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[DeleteCertificateRequest, AwsError, Unit]
  object DescribeJobTemplate
      extends Effect[
        DescribeJobTemplateRequest,
        AwsError,
        zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly
      ]
  object DeleteFleetMetric
      extends Effect[DeleteFleetMetricRequest, AwsError, Unit]
  object SetDefaultPolicyVersion
      extends Effect[SetDefaultPolicyVersionRequest, AwsError, Unit]
  object DeleteCACertificate
      extends Effect[
        DeleteCaCertificateRequest,
        AwsError,
        zio.aws.iot.model.DeleteCaCertificateResponse.ReadOnly
      ]
  object DeleteV2LoggingLevel
      extends Effect[DeleteV2LoggingLevelRequest, AwsError, Unit]
  object ListAuditFindings
      extends Stream[
        ListAuditFindingsRequest,
        AwsError,
        zio.aws.iot.model.AuditFinding.ReadOnly
      ]
  object ListAuditFindingsPaginated
      extends Effect[
        ListAuditFindingsRequest,
        AwsError,
        zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly
      ]
  object ValidateSecurityProfileBehaviors
      extends Effect[
        ValidateSecurityProfileBehaviorsRequest,
        AwsError,
        zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly
      ]
  object ListRoleAliases
      extends Stream[ListRoleAliasesRequest, AwsError, RoleAlias]
  object ListRoleAliasesPaginated
      extends Effect[
        ListRoleAliasesRequest,
        AwsError,
        zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly
      ]
  object ListCertificatesByCA
      extends Stream[
        ListCertificatesByCaRequest,
        AwsError,
        zio.aws.iot.model.Certificate.ReadOnly
      ]
  object ListCertificatesByCAPaginated
      extends Effect[
        ListCertificatesByCaRequest,
        AwsError,
        zio.aws.iot.model.ListCertificatesByCaResponse.ReadOnly
      ]
  object UpdateAccountAuditConfiguration
      extends Effect[
        UpdateAccountAuditConfigurationRequest,
        AwsError,
        zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.ReadOnly
      ]
  object DescribeSecurityProfile
      extends Effect[
        DescribeSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly
      ]
  object ListAuthorizers
      extends Stream[
        ListAuthorizersRequest,
        AwsError,
        zio.aws.iot.model.AuthorizerSummary.ReadOnly
      ]
  object ListAuthorizersPaginated
      extends Effect[
        ListAuthorizersRequest,
        AwsError,
        zio.aws.iot.model.ListAuthorizersResponse.ReadOnly
      ]
  object DeleteStream
      extends Effect[
        DeleteStreamRequest,
        AwsError,
        zio.aws.iot.model.DeleteStreamResponse.ReadOnly
      ]
  object DeleteOTAUpdate
      extends Effect[
        DeleteOtaUpdateRequest,
        AwsError,
        zio.aws.iot.model.DeleteOtaUpdateResponse.ReadOnly
      ]
  object UpdateMitigationAction
      extends Effect[
        UpdateMitigationActionRequest,
        AwsError,
        zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly
      ]
  object ClearDefaultAuthorizer
      extends Effect[
        ClearDefaultAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.ClearDefaultAuthorizerResponse.ReadOnly
      ]
  object DeleteScheduledAudit
      extends Effect[
        DeleteScheduledAuditRequest,
        AwsError,
        zio.aws.iot.model.DeleteScheduledAuditResponse.ReadOnly
      ]
  object ListPolicies
      extends Stream[
        ListPoliciesRequest,
        AwsError,
        zio.aws.iot.model.Policy.ReadOnly
      ]
  object ListPoliciesPaginated
      extends Effect[
        ListPoliciesRequest,
        AwsError,
        zio.aws.iot.model.ListPoliciesResponse.ReadOnly
      ]
  object DescribeProvisioningTemplateVersion
      extends Effect[
        DescribeProvisioningTemplateVersionRequest,
        AwsError,
        zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly
      ]
  object ListCustomMetrics
      extends Stream[ListCustomMetricsRequest, AwsError, MetricName]
  object ListCustomMetricsPaginated
      extends Effect[
        ListCustomMetricsRequest,
        AwsError,
        zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly
      ]
  object ListOTAUpdates
      extends Stream[
        ListOtaUpdatesRequest,
        AwsError,
        zio.aws.iot.model.OTAUpdateSummary.ReadOnly
      ]
  object ListOTAUpdatesPaginated
      extends Effect[
        ListOtaUpdatesRequest,
        AwsError,
        zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly
      ]
  object ReplaceTopicRule
      extends Effect[ReplaceTopicRuleRequest, AwsError, Unit]
  object GetV2LoggingOptions
      extends Effect[
        GetV2LoggingOptionsRequest,
        AwsError,
        zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly
      ]
  object DescribeStream
      extends Effect[
        DescribeStreamRequest,
        AwsError,
        zio.aws.iot.model.DescribeStreamResponse.ReadOnly
      ]
  object ListMitigationActions
      extends Stream[
        ListMitigationActionsRequest,
        AwsError,
        zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
      ]
  object ListMitigationActionsPaginated
      extends Effect[
        ListMitigationActionsRequest,
        AwsError,
        zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly
      ]
  object CancelCertificateTransfer
      extends Effect[CancelCertificateTransferRequest, AwsError, Unit]
  object CreateStream
      extends Effect[
        CreateStreamRequest,
        AwsError,
        zio.aws.iot.model.CreateStreamResponse.ReadOnly
      ]
  object AcceptCertificateTransfer
      extends Effect[AcceptCertificateTransferRequest, AwsError, Unit]
  object ListDetectMitigationActionsExecutions
      extends Stream[
        ListDetectMitigationActionsExecutionsRequest,
        AwsError,
        zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
      ]
  object ListDetectMitigationActionsExecutionsPaginated
      extends Effect[
        ListDetectMitigationActionsExecutionsRequest,
        AwsError,
        zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly
      ]
  object CreateTopicRule extends Effect[CreateTopicRuleRequest, AwsError, Unit]
  object DeletePolicyVersion
      extends Effect[DeletePolicyVersionRequest, AwsError, Unit]
  object ListTopicRuleDestinations
      extends Stream[
        ListTopicRuleDestinationsRequest,
        AwsError,
        zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
      ]
  object ListTopicRuleDestinationsPaginated
      extends Effect[
        ListTopicRuleDestinationsRequest,
        AwsError,
        zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly
      ]
  object SearchIndex
      extends Effect[
        SearchIndexRequest,
        AwsError,
        zio.aws.iot.model.SearchIndexResponse.ReadOnly
      ]
  object AttachSecurityProfile
      extends Effect[
        AttachSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.AttachSecurityProfileResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iot.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateCertificate
      extends Effect[UpdateCertificateRequest, AwsError, Unit]
  object CreateFleetMetric
      extends Effect[
        CreateFleetMetricRequest,
        AwsError,
        zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly
      ]
  object DescribeEndpoint
      extends Effect[
        DescribeEndpointRequest,
        AwsError,
        zio.aws.iot.model.DescribeEndpointResponse.ReadOnly
      ]
  object UpdateProvisioningTemplate
      extends Effect[
        UpdateProvisioningTemplateRequest,
        AwsError,
        zio.aws.iot.model.UpdateProvisioningTemplateResponse.ReadOnly
      ]
  object ListSecurityProfiles
      extends Stream[
        ListSecurityProfilesRequest,
        AwsError,
        zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
      ]
  object ListSecurityProfilesPaginated
      extends Effect[
        ListSecurityProfilesRequest,
        AwsError,
        zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly
      ]
  object DeleteTopicRuleDestination
      extends Effect[
        DeleteTopicRuleDestinationRequest,
        AwsError,
        zio.aws.iot.model.DeleteTopicRuleDestinationResponse.ReadOnly
      ]
  object CreateCertificateFromCsr
      extends Effect[
        CreateCertificateFromCsrRequest,
        AwsError,
        zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly
      ]
  object CreateRoleAlias
      extends Effect[
        CreateRoleAliasRequest,
        AwsError,
        zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly
      ]
  object RegisterCACertificate
      extends Effect[
        RegisterCaCertificateRequest,
        AwsError,
        zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly
      ]
  object SetV2LoggingOptions
      extends Effect[SetV2LoggingOptionsRequest, AwsError, Unit]
  object GetStatistics
      extends Effect[
        GetStatisticsRequest,
        AwsError,
        zio.aws.iot.model.GetStatisticsResponse.ReadOnly
      ]
  object ListDimensions
      extends Stream[ListDimensionsRequest, AwsError, DimensionName]
  object ListDimensionsPaginated
      extends Effect[
        ListDimensionsRequest,
        AwsError,
        zio.aws.iot.model.ListDimensionsResponse.ReadOnly
      ]
  object CreateThingGroup
      extends Effect[
        CreateThingGroupRequest,
        AwsError,
        zio.aws.iot.model.CreateThingGroupResponse.ReadOnly
      ]
  object ListDetectMitigationActionsTasks
      extends Stream[
        ListDetectMitigationActionsTasksRequest,
        AwsError,
        zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
      ]
  object ListDetectMitigationActionsTasksPaginated
      extends Effect[
        ListDetectMitigationActionsTasksRequest,
        AwsError,
        zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.ReadOnly
      ]
  object UpdateFleetMetric
      extends Effect[UpdateFleetMetricRequest, AwsError, Unit]
  object DeleteTopicRule extends Effect[DeleteTopicRuleRequest, AwsError, Unit]
  object CreateMitigationAction
      extends Effect[
        CreateMitigationActionRequest,
        AwsError,
        zio.aws.iot.model.CreateMitigationActionResponse.ReadOnly
      ]
  object DescribeCustomMetric
      extends Effect[
        DescribeCustomMetricRequest,
        AwsError,
        zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly
      ]
  object DescribeDetectMitigationActionsTask
      extends Effect[
        DescribeDetectMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly
      ]
  object ListBillingGroups
      extends Stream[
        ListBillingGroupsRequest,
        AwsError,
        zio.aws.iot.model.GroupNameAndArn.ReadOnly
      ]
  object ListBillingGroupsPaginated
      extends Effect[
        ListBillingGroupsRequest,
        AwsError,
        zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly
      ]
  object UpdateJob extends Effect[UpdateJobRequest, AwsError, Unit]
  object CreateAuthorizer
      extends Effect[
        CreateAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly
      ]
  object SetDefaultAuthorizer
      extends Effect[
        SetDefaultAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.SetDefaultAuthorizerResponse.ReadOnly
      ]
  object DeleteRoleAlias
      extends Effect[
        DeleteRoleAliasRequest,
        AwsError,
        zio.aws.iot.model.DeleteRoleAliasResponse.ReadOnly
      ]
  object AttachPolicy extends Effect[AttachPolicyRequest, AwsError, Unit]
  object ListThingRegistrationTasks
      extends Stream[ListThingRegistrationTasksRequest, AwsError, TaskId]
  object ListThingRegistrationTasksPaginated
      extends Effect[
        ListThingRegistrationTasksRequest,
        AwsError,
        zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly
      ]
  object DescribeAuditSuppression
      extends Effect[
        DescribeAuditSuppressionRequest,
        AwsError,
        zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly
      ]
  object ListThingPrincipals
      extends Stream[ListThingPrincipalsRequest, AwsError, PrincipalArn]
  object ListThingPrincipalsPaginated
      extends Effect[
        ListThingPrincipalsRequest,
        AwsError,
        zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iot.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iot.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteThing
      extends Effect[
        DeleteThingRequest,
        AwsError,
        zio.aws.iot.model.DeleteThingResponse.ReadOnly
      ]
  object ListAuditMitigationActionsTasks
      extends Stream[
        ListAuditMitigationActionsTasksRequest,
        AwsError,
        zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly
      ]
  object ListAuditMitigationActionsTasksPaginated
      extends Effect[
        ListAuditMitigationActionsTasksRequest,
        AwsError,
        zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.iot.model.JobSummary.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.iot.model.ListJobsResponse.ReadOnly
      ]
  object CreateCustomMetric
      extends Effect[
        CreateCustomMetricRequest,
        AwsError,
        zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly
      ]
  object CreatePolicy
      extends Effect[
        CreatePolicyRequest,
        AwsError,
        zio.aws.iot.model.CreatePolicyResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iot.model.TagResourceResponse.ReadOnly
      ]
  object EnableTopicRule extends Effect[EnableTopicRuleRequest, AwsError, Unit]
  object DeleteThingType
      extends Effect[
        DeleteThingTypeRequest,
        AwsError,
        zio.aws.iot.model.DeleteThingTypeResponse.ReadOnly
      ]
  object ListManagedJobTemplates
      extends Effect[
        ListManagedJobTemplatesRequest,
        AwsError,
        zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly
      ]
  object ListThingsInThingGroup
      extends Stream[ListThingsInThingGroupRequest, AwsError, ThingName]
  object ListThingsInThingGroupPaginated
      extends Effect[
        ListThingsInThingGroupRequest,
        AwsError,
        zio.aws.iot.model.ListThingsInThingGroupResponse.ReadOnly
      ]
  object GetTopicRule
      extends Effect[
        GetTopicRuleRequest,
        AwsError,
        zio.aws.iot.model.GetTopicRuleResponse.ReadOnly
      ]
  object ListScheduledAudits
      extends Stream[
        ListScheduledAuditsRequest,
        AwsError,
        zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly
      ]
  object ListScheduledAuditsPaginated
      extends Effect[
        ListScheduledAuditsRequest,
        AwsError,
        zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly
      ]
  object StartThingRegistrationTask
      extends Effect[
        StartThingRegistrationTaskRequest,
        AwsError,
        zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly
      ]
  object ListV2LoggingLevels
      extends Stream[
        ListV2LoggingLevelsRequest,
        AwsError,
        zio.aws.iot.model.LogTargetConfiguration.ReadOnly
      ]
  object ListV2LoggingLevelsPaginated
      extends Effect[
        ListV2LoggingLevelsRequest,
        AwsError,
        zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly
      ]
  object DeletePolicy extends Effect[DeletePolicyRequest, AwsError, Unit]
  object DeleteAuthorizer
      extends Effect[
        DeleteAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.DeleteAuthorizerResponse.ReadOnly
      ]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.iot.model.GetPolicyResponse.ReadOnly
      ]
  object StartAuditMitigationActionsTask
      extends Effect[
        StartAuditMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly
      ]
  object TransferCertificate
      extends Effect[
        TransferCertificateRequest,
        AwsError,
        zio.aws.iot.model.TransferCertificateResponse.ReadOnly
      ]
  object AddThingToThingGroup
      extends Effect[
        AddThingToThingGroupRequest,
        AwsError,
        zio.aws.iot.model.AddThingToThingGroupResponse.ReadOnly
      ]
  object StartDetectMitigationActionsTask
      extends Effect[
        StartDetectMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly
      ]
  object AssociateTargetsWithJob
      extends Effect[
        AssociateTargetsWithJobRequest,
        AwsError,
        zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly
      ]
  object DescribeEventConfigurations
      extends Effect[
        DescribeEventConfigurationsRequest,
        AwsError,
        zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly
      ]
  object DescribeThingType
      extends Effect[
        DescribeThingTypeRequest,
        AwsError,
        zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly
      ]
  object ListJobExecutionsForThing
      extends Stream[
        ListJobExecutionsForThingRequest,
        AwsError,
        zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
      ]
  object ListJobExecutionsForThingPaginated
      extends Effect[
        ListJobExecutionsForThingRequest,
        AwsError,
        zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly
      ]
  object UpdateRoleAlias
      extends Effect[
        UpdateRoleAliasRequest,
        AwsError,
        zio.aws.iot.model.UpdateRoleAliasResponse.ReadOnly
      ]
  object ListProvisioningTemplates
      extends Stream[
        ListProvisioningTemplatesRequest,
        AwsError,
        zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
      ]
  object ListProvisioningTemplatesPaginated
      extends Effect[
        ListProvisioningTemplatesRequest,
        AwsError,
        zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly
      ]
  object ListThingTypes
      extends Stream[
        ListThingTypesRequest,
        AwsError,
        zio.aws.iot.model.ThingTypeDefinition.ReadOnly
      ]
  object ListThingTypesPaginated
      extends Effect[
        ListThingTypesRequest,
        AwsError,
        zio.aws.iot.model.ListThingTypesResponse.ReadOnly
      ]
  object DisableTopicRule
      extends Effect[DisableTopicRuleRequest, AwsError, Unit]
  object RegisterCertificate
      extends Effect[
        RegisterCertificateRequest,
        AwsError,
        zio.aws.iot.model.RegisterCertificateResponse.ReadOnly
      ]
  object DescribeDimension
      extends Effect[
        DescribeDimensionRequest,
        AwsError,
        zio.aws.iot.model.DescribeDimensionResponse.ReadOnly
      ]
  object CreatePolicyVersion
      extends Effect[
        CreatePolicyVersionRequest,
        AwsError,
        zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly
      ]
  object DeleteRegistrationCode
      extends Effect[
        DeleteRegistrationCodeRequest,
        AwsError,
        zio.aws.iot.model.DeleteRegistrationCodeResponse.ReadOnly
      ]
  object DescribeBillingGroup
      extends Effect[
        DescribeBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly
      ]
  object UpdateSecurityProfile
      extends Effect[
        UpdateSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.UpdateSecurityProfileResponse.ReadOnly
      ]
  object UpdateTopicRuleDestination
      extends Effect[
        UpdateTopicRuleDestinationRequest,
        AwsError,
        zio.aws.iot.model.UpdateTopicRuleDestinationResponse.ReadOnly
      ]
  object UpdateBillingGroup
      extends Effect[
        UpdateBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly
      ]
  object GetEffectivePolicies
      extends Effect[
        GetEffectivePoliciesRequest,
        AwsError,
        zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly
      ]
  object ListAuditTasks
      extends Stream[
        ListAuditTasksRequest,
        AwsError,
        zio.aws.iot.model.AuditTaskMetadata.ReadOnly
      ]
  object ListAuditTasksPaginated
      extends Effect[
        ListAuditTasksRequest,
        AwsError,
        zio.aws.iot.model.ListAuditTasksResponse.ReadOnly
      ]
  object DescribeCertificate
      extends Effect[
        DescribeCertificateRequest,
        AwsError,
        zio.aws.iot.model.DescribeCertificateResponse.ReadOnly
      ]
  object DescribeAuditMitigationActionsTask
      extends Effect[
        DescribeAuditMitigationActionsTaskRequest,
        AwsError,
        zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly
      ]
  object CreateThingType
      extends Effect[
        CreateThingTypeRequest,
        AwsError,
        zio.aws.iot.model.CreateThingTypeResponse.ReadOnly
      ]
  object CreateAuditSuppression
      extends Effect[
        CreateAuditSuppressionRequest,
        AwsError,
        zio.aws.iot.model.CreateAuditSuppressionResponse.ReadOnly
      ]
  object GetLoggingOptions
      extends Effect[
        GetLoggingOptionsRequest,
        AwsError,
        zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly
      ]
  object ListThingGroupsForThing
      extends Stream[
        ListThingGroupsForThingRequest,
        AwsError,
        zio.aws.iot.model.GroupNameAndArn.ReadOnly
      ]
  object ListThingGroupsForThingPaginated
      extends Effect[
        ListThingGroupsForThingRequest,
        AwsError,
        zio.aws.iot.model.ListThingGroupsForThingResponse.ReadOnly
      ]
  object GetBucketsAggregation
      extends Effect[
        GetBucketsAggregationRequest,
        AwsError,
        zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly
      ]
  object RemoveThingFromBillingGroup
      extends Effect[
        RemoveThingFromBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.RemoveThingFromBillingGroupResponse.ReadOnly
      ]
  object ListCertificates
      extends Stream[
        ListCertificatesRequest,
        AwsError,
        zio.aws.iot.model.Certificate.ReadOnly
      ]
  object ListCertificatesPaginated
      extends Effect[
        ListCertificatesRequest,
        AwsError,
        zio.aws.iot.model.ListCertificatesResponse.ReadOnly
      ]
  object GetPolicyVersion
      extends Effect[
        GetPolicyVersionRequest,
        AwsError,
        zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly
      ]
  object DescribeRoleAlias
      extends Effect[
        DescribeRoleAliasRequest,
        AwsError,
        zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly
      ]
  object DeleteProvisioningTemplate
      extends Effect[
        DeleteProvisioningTemplateRequest,
        AwsError,
        zio.aws.iot.model.DeleteProvisioningTemplateResponse.ReadOnly
      ]
  object UpdateDynamicThingGroup
      extends Effect[
        UpdateDynamicThingGroupRequest,
        AwsError,
        zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly
      ]
  object CreateDimension
      extends Effect[
        CreateDimensionRequest,
        AwsError,
        zio.aws.iot.model.CreateDimensionResponse.ReadOnly
      ]
  object DeprecateThingType
      extends Effect[
        DeprecateThingTypeRequest,
        AwsError,
        zio.aws.iot.model.DeprecateThingTypeResponse.ReadOnly
      ]
  object AddThingToBillingGroup
      extends Effect[
        AddThingToBillingGroupRequest,
        AwsError,
        zio.aws.iot.model.AddThingToBillingGroupResponse.ReadOnly
      ]
  object DescribeDefaultAuthorizer
      extends Effect[
        DescribeDefaultAuthorizerRequest,
        AwsError,
        zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly
      ]
  object TestAuthorization
      extends Effect[
        TestAuthorizationRequest,
        AwsError,
        zio.aws.iot.model.TestAuthorizationResponse.ReadOnly
      ]
  object ListOutgoingCertificates
      extends Stream[
        ListOutgoingCertificatesRequest,
        AwsError,
        zio.aws.iot.model.OutgoingCertificate.ReadOnly
      ]
  object ListOutgoingCertificatesPaginated
      extends Effect[
        ListOutgoingCertificatesRequest,
        AwsError,
        zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly
      ]
  object ConfirmTopicRuleDestination
      extends Effect[
        ConfirmTopicRuleDestinationRequest,
        AwsError,
        zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.ReadOnly
      ]
  object DeleteAccountAuditConfiguration
      extends Effect[
        DeleteAccountAuditConfigurationRequest,
        AwsError,
        zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.ReadOnly
      ]
  object DescribeFleetMetric
      extends Effect[
        DescribeFleetMetricRequest,
        AwsError,
        zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly
      ]
  object ListThings
      extends Stream[
        ListThingsRequest,
        AwsError,
        zio.aws.iot.model.ThingAttribute.ReadOnly
      ]
  object ListThingsPaginated
      extends Effect[
        ListThingsRequest,
        AwsError,
        zio.aws.iot.model.ListThingsResponse.ReadOnly
      ]
  object DescribeAuditTask
      extends Effect[
        DescribeAuditTaskRequest,
        AwsError,
        zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly
      ]
  object UpdateEventConfigurations
      extends Effect[
        UpdateEventConfigurationsRequest,
        AwsError,
        zio.aws.iot.model.UpdateEventConfigurationsResponse.ReadOnly
      ]
  object DeleteJob extends Effect[DeleteJobRequest, AwsError, Unit]
  object ListThingRegistrationTaskReports
      extends Stream[
        ListThingRegistrationTaskReportsRequest,
        AwsError,
        S3FileUrl
      ]
  object ListThingRegistrationTaskReportsPaginated
      extends Effect[
        ListThingRegistrationTaskReportsRequest,
        AwsError,
        zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly
      ]
  object CreateJobTemplate
      extends Effect[
        CreateJobTemplateRequest,
        AwsError,
        zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly
      ]
  object ListFleetMetrics
      extends Stream[
        ListFleetMetricsRequest,
        AwsError,
        zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly
      ]
  object ListFleetMetricsPaginated
      extends Effect[
        ListFleetMetricsRequest,
        AwsError,
        zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly
      ]
  object ListActiveViolations
      extends Stream[
        ListActiveViolationsRequest,
        AwsError,
        zio.aws.iot.model.ActiveViolation.ReadOnly
      ]
  object ListActiveViolationsPaginated
      extends Effect[
        ListActiveViolationsRequest,
        AwsError,
        zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly
      ]
  object CancelAuditTask
      extends Effect[
        CancelAuditTaskRequest,
        AwsError,
        zio.aws.iot.model.CancelAuditTaskResponse.ReadOnly
      ]
  object DeleteDynamicThingGroup
      extends Effect[
        DeleteDynamicThingGroupRequest,
        AwsError,
        zio.aws.iot.model.DeleteDynamicThingGroupResponse.ReadOnly
      ]
  object DetachSecurityProfile
      extends Effect[
        DetachSecurityProfileRequest,
        AwsError,
        zio.aws.iot.model.DetachSecurityProfileResponse.ReadOnly
      ]
  object CreateThing
      extends Effect[
        CreateThingRequest,
        AwsError,
        zio.aws.iot.model.CreateThingResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Iot] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Iot {
          val api: IotAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Iot = this
          def deleteCustomMetric(request: DeleteCustomMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.DeleteCustomMetricResponse.ReadOnly
          ] = proxy(DeleteCustomMetric, request)
          def createProvisioningTemplateVersion(
              request: CreateProvisioningTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly
          ] = proxy(CreateProvisioningTemplateVersion, request)
          def registerThing(
              request: RegisterThingRequest
          ): IO[AwsError, zio.aws.iot.model.RegisterThingResponse.ReadOnly] =
            proxy(RegisterThing, request)
          def listProvisioningTemplateVersions(
              request: ListProvisioningTemplateVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListProvisioningTemplateVersions, request))
          def listProvisioningTemplateVersionsPaginated(
              request: ListProvisioningTemplateVersionsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly
          ] = proxy(ListProvisioningTemplateVersionsPaginated, request)
          def updateAuditSuppression(
              request: UpdateAuditSuppressionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateAuditSuppressionResponse.ReadOnly
          ] = proxy(UpdateAuditSuppression, request)
          def listTargetsForSecurityProfile(
              request: ListTargetsForSecurityProfileRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.SecurityProfileTarget.ReadOnly
          ] = rts.unsafeRun(proxy(ListTargetsForSecurityProfile, request))
          def listTargetsForSecurityProfilePaginated(
              request: ListTargetsForSecurityProfileRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly
          ] = proxy(ListTargetsForSecurityProfilePaginated, request)
          def createDynamicThingGroup(
              request: CreateDynamicThingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly
          ] = proxy(CreateDynamicThingGroup, request)
          def listStreams(
              request: ListStreamsRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.StreamSummary.ReadOnly] =
            rts.unsafeRun(proxy(ListStreams, request))
          def listStreamsPaginated(
              request: ListStreamsRequest
          ): IO[AwsError, zio.aws.iot.model.ListStreamsResponse.ReadOnly] =
            proxy(ListStreamsPaginated, request)
          def createTopicRuleDestination(
              request: CreateTopicRuleDestinationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly
          ] = proxy(CreateTopicRuleDestination, request)
          def createScheduledAudit(request: CreateScheduledAuditRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly
          ] = proxy(CreateScheduledAudit, request)
          def describeJob(
              request: DescribeJobRequest
          ): IO[AwsError, zio.aws.iot.model.DescribeJobResponse.ReadOnly] =
            proxy(DescribeJob, request)
          def createOTAUpdate(
              request: CreateOtaUpdateRequest
          ): IO[AwsError, zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly] =
            proxy(CreateOTAUpdate, request)
          def deleteDomainConfiguration(
              request: DeleteDomainConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteDomainConfigurationResponse.ReadOnly
          ] = proxy(DeleteDomainConfiguration, request)
          def setV2LoggingLevel(
              request: SetV2LoggingLevelRequest
          ): IO[AwsError, Unit] = proxy(SetV2LoggingLevel, request)
          def deleteJobExecution(
              request: DeleteJobExecutionRequest
          ): IO[AwsError, Unit] = proxy(DeleteJobExecution, request)
          def testInvokeAuthorizer(request: TestInvokeAuthorizerRequest): IO[
            AwsError,
            zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly
          ] = proxy(TestInvokeAuthorizer, request)
          def updateCACertificate(
              request: UpdateCaCertificateRequest
          ): IO[AwsError, Unit] = proxy(UpdateCACertificate, request)
          def deleteDimension(
              request: DeleteDimensionRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteDimensionResponse.ReadOnly] =
            proxy(DeleteDimension, request)
          def listIndices(
              request: ListIndicesRequest
          ): ZStream[Any, AwsError, IndexName] =
            rts.unsafeRun(proxy(ListIndices, request))
          def listIndicesPaginated(
              request: ListIndicesRequest
          ): IO[AwsError, zio.aws.iot.model.ListIndicesResponse.ReadOnly] =
            proxy(ListIndicesPaginated, request)
          def removeThingFromThingGroup(
              request: RemoveThingFromThingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.RemoveThingFromThingGroupResponse.ReadOnly
          ] = proxy(RemoveThingFromThingGroup, request)
          def describeAuthorizer(request: DescribeAuthorizerRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly
          ] = proxy(DescribeAuthorizer, request)
          def updateIndexingConfiguration(
              request: UpdateIndexingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateIndexingConfigurationResponse.ReadOnly
          ] = proxy(UpdateIndexingConfiguration, request)
          def cancelJobExecution(
              request: CancelJobExecutionRequest
          ): IO[AwsError, Unit] = proxy(CancelJobExecution, request)
          def detachThingPrincipal(request: DetachThingPrincipalRequest): IO[
            AwsError,
            zio.aws.iot.model.DetachThingPrincipalResponse.ReadOnly
          ] = proxy(DetachThingPrincipal, request)
          def deleteBillingGroup(request: DeleteBillingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.DeleteBillingGroupResponse.ReadOnly
          ] = proxy(DeleteBillingGroup, request)
          def createKeysAndCertificate(
              request: CreateKeysAndCertificateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly
          ] = proxy(CreateKeysAndCertificate, request)
          def updateScheduledAudit(request: UpdateScheduledAuditRequest): IO[
            AwsError,
            zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly
          ] = proxy(UpdateScheduledAudit, request)
          def deleteThingGroup(
              request: DeleteThingGroupRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteThingGroupResponse.ReadOnly] =
            proxy(DeleteThingGroup, request)
          def listJobTemplates(request: ListJobTemplatesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.JobTemplateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobTemplates, request))
          def listJobTemplatesPaginated(
              request: ListJobTemplatesRequest
          ): IO[AwsError, zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly] =
            proxy(ListJobTemplatesPaginated, request)
          def describeProvisioningTemplate(
              request: DescribeProvisioningTemplateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly
          ] = proxy(DescribeProvisioningTemplate, request)
          def listSecurityProfilesForTarget(
              request: ListSecurityProfilesForTargetRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
          ] = rts.unsafeRun(proxy(ListSecurityProfilesForTarget, request))
          def listSecurityProfilesForTargetPaginated(
              request: ListSecurityProfilesForTargetRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly
          ] = proxy(ListSecurityProfilesForTargetPaginated, request)
          def cancelDetectMitigationActionsTask(
              request: CancelDetectMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.ReadOnly
          ] = proxy(CancelDetectMitigationActionsTask, request)
          def getIndexingConfiguration(
              request: GetIndexingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly
          ] = proxy(GetIndexingConfiguration, request)
          def stopThingRegistrationTask(
              request: StopThingRegistrationTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.StopThingRegistrationTaskResponse.ReadOnly
          ] = proxy(StopThingRegistrationTask, request)
          def createSecurityProfile(request: CreateSecurityProfileRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly
          ] = proxy(CreateSecurityProfile, request)
          def updateDimension(
              request: UpdateDimensionRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateDimensionResponse.ReadOnly] =
            proxy(UpdateDimension, request)
          def updateCustomMetric(request: UpdateCustomMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly
          ] = proxy(UpdateCustomMetric, request)
          def describeThingRegistrationTask(
              request: DescribeThingRegistrationTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly
          ] = proxy(DescribeThingRegistrationTask, request)
          def listCACertificates(
              request: ListCaCertificatesRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.CACertificate.ReadOnly] =
            rts.unsafeRun(proxy(ListCACertificates, request))
          def listCACertificatesPaginated(
              request: ListCaCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly
          ] = proxy(ListCACertificatesPaginated, request)
          def deleteProvisioningTemplateVersion(
              request: DeleteProvisioningTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.ReadOnly
          ] = proxy(DeleteProvisioningTemplateVersion, request)
          def getCardinality(
              request: GetCardinalityRequest
          ): IO[AwsError, zio.aws.iot.model.GetCardinalityResponse.ReadOnly] =
            proxy(GetCardinality, request)
          def listDomainConfigurations(
              request: ListDomainConfigurationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDomainConfigurations, request))
          def listDomainConfigurationsPaginated(
              request: ListDomainConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly
          ] = proxy(ListDomainConfigurationsPaginated, request)
          def describeAccountAuditConfiguration(
              request: DescribeAccountAuditConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly
          ] = proxy(DescribeAccountAuditConfiguration, request)
          def putVerificationStateOnViolation(
              request: PutVerificationStateOnViolationRequest
          ): IO[AwsError, ReadOnly] =
            proxy(PutVerificationStateOnViolation, request)
          def listPrincipalThings(
              request: ListPrincipalThingsRequest
          ): ZStream[Any, AwsError, ThingName] =
            rts.unsafeRun(proxy(ListPrincipalThings, request))
          def listPrincipalThingsPaginated(
              request: ListPrincipalThingsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly
          ] = proxy(ListPrincipalThingsPaginated, request)
          def getBehaviorModelTrainingSummaries(
              request: GetBehaviorModelTrainingSummariesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
          ] = rts.unsafeRun(proxy(GetBehaviorModelTrainingSummaries, request))
          def getBehaviorModelTrainingSummariesPaginated(
              request: GetBehaviorModelTrainingSummariesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly
          ] = proxy(GetBehaviorModelTrainingSummariesPaginated, request)
          def describeScheduledAudit(
              request: DescribeScheduledAuditRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly
          ] = proxy(DescribeScheduledAudit, request)
          def updateThingGroupsForThing(
              request: UpdateThingGroupsForThingRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateThingGroupsForThingResponse.ReadOnly
          ] = proxy(UpdateThingGroupsForThing, request)
          def updateThing(
              request: UpdateThingRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateThingResponse.ReadOnly] =
            proxy(UpdateThing, request)
          def describeThing(
              request: DescribeThingRequest
          ): IO[AwsError, zio.aws.iot.model.DescribeThingResponse.ReadOnly] =
            proxy(DescribeThing, request)
          def createProvisioningClaim(
              request: CreateProvisioningClaimRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly
          ] = proxy(CreateProvisioningClaim, request)
          def getPercentiles(
              request: GetPercentilesRequest
          ): IO[AwsError, zio.aws.iot.model.GetPercentilesResponse.ReadOnly] =
            proxy(GetPercentiles, request)
          def deleteMitigationAction(
              request: DeleteMitigationActionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteMitigationActionResponse.ReadOnly
          ] = proxy(DeleteMitigationAction, request)
          def describeJobExecution(request: DescribeJobExecutionRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly
          ] = proxy(DescribeJobExecution, request)
          def updateStream(
              request: UpdateStreamRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateStreamResponse.ReadOnly] =
            proxy(UpdateStream, request)
          def deleteAuditSuppression(
              request: DeleteAuditSuppressionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteAuditSuppressionResponse.ReadOnly
          ] = proxy(DeleteAuditSuppression, request)
          def deleteJobTemplate(
              request: DeleteJobTemplateRequest
          ): IO[AwsError, Unit] = proxy(DeleteJobTemplate, request)
          def getJobDocument(
              request: GetJobDocumentRequest
          ): IO[AwsError, zio.aws.iot.model.GetJobDocumentResponse.ReadOnly] =
            proxy(GetJobDocument, request)
          def getRegistrationCode(request: GetRegistrationCodeRequest): IO[
            AwsError,
            zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly
          ] = proxy(GetRegistrationCode, request)
          def updateThingGroup(
              request: UpdateThingGroupRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly] =
            proxy(UpdateThingGroup, request)
          def listJobExecutionsForJob(
              request: ListJobExecutionsForJobRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobExecutionsForJob, request))
          def listJobExecutionsForJobPaginated(
              request: ListJobExecutionsForJobRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListJobExecutionsForJobResponse.ReadOnly
          ] = proxy(ListJobExecutionsForJobPaginated, request)
          def listAuditSuppressions(
              request: ListAuditSuppressionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.AuditSuppression.ReadOnly
          ] = rts.unsafeRun(proxy(ListAuditSuppressions, request))
          def listAuditSuppressionsPaginated(
              request: ListAuditSuppressionsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly
          ] = proxy(ListAuditSuppressionsPaginated, request)
          def describeManagedJobTemplate(
              request: DescribeManagedJobTemplateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly
          ] = proxy(DescribeManagedJobTemplate, request)
          def createBillingGroup(request: CreateBillingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly
          ] = proxy(CreateBillingGroup, request)
          def listTargetsForPolicy(
              request: ListTargetsForPolicyRequest
          ): ZStream[Any, AwsError, PolicyTarget] =
            rts.unsafeRun(proxy(ListTargetsForPolicy, request))
          def listTargetsForPolicyPaginated(
              request: ListTargetsForPolicyRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly
          ] = proxy(ListTargetsForPolicyPaginated, request)
          def describeDomainConfiguration(
              request: DescribeDomainConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly
          ] = proxy(DescribeDomainConfiguration, request)
          def describeCACertificate(request: DescribeCaCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly
          ] = proxy(DescribeCACertificate, request)
          def updateDomainConfiguration(
              request: UpdateDomainConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly
          ] = proxy(UpdateDomainConfiguration, request)
          def createJob(
              request: CreateJobRequest
          ): IO[AwsError, zio.aws.iot.model.CreateJobResponse.ReadOnly] =
            proxy(CreateJob, request)
          def setLoggingOptions(
              request: SetLoggingOptionsRequest
          ): IO[AwsError, Unit] = proxy(SetLoggingOptions, request)
          def listAttachedPolicies(
              request: ListAttachedPoliciesRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
            rts.unsafeRun(proxy(ListAttachedPolicies, request))
          def listAttachedPoliciesPaginated(
              request: ListAttachedPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListAttachedPoliciesResponse.ReadOnly
          ] = proxy(ListAttachedPoliciesPaginated, request)
          def detachPolicy(request: DetachPolicyRequest): IO[AwsError, Unit] =
            proxy(DetachPolicy, request)
          def describeIndex(
              request: DescribeIndexRequest
          ): IO[AwsError, zio.aws.iot.model.DescribeIndexResponse.ReadOnly] =
            proxy(DescribeIndex, request)
          def cancelAuditMitigationActionsTask(
              request: CancelAuditMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.ReadOnly
          ] = proxy(CancelAuditMitigationActionsTask, request)
          def attachThingPrincipal(request: AttachThingPrincipalRequest): IO[
            AwsError,
            zio.aws.iot.model.AttachThingPrincipalResponse.ReadOnly
          ] = proxy(AttachThingPrincipal, request)
          def describeMitigationAction(
              request: DescribeMitigationActionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly
          ] = proxy(DescribeMitigationAction, request)
          def createProvisioningTemplate(
              request: CreateProvisioningTemplateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly
          ] = proxy(CreateProvisioningTemplate, request)
          def listThingsInBillingGroup(
              request: ListThingsInBillingGroupRequest
          ): ZStream[Any, AwsError, ThingName] =
            rts.unsafeRun(proxy(ListThingsInBillingGroup, request))
          def listThingsInBillingGroupPaginated(
              request: ListThingsInBillingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingsInBillingGroupResponse.ReadOnly
          ] = proxy(ListThingsInBillingGroupPaginated, request)
          def cancelJob(
              request: CancelJobRequest
          ): IO[AwsError, zio.aws.iot.model.CancelJobResponse.ReadOnly] =
            proxy(CancelJob, request)
          def listViolationEvents(
              request: ListViolationEventsRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.ViolationEvent.ReadOnly] =
            rts.unsafeRun(proxy(ListViolationEvents, request))
          def listViolationEventsPaginated(
              request: ListViolationEventsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListViolationEventsResponse.ReadOnly
          ] = proxy(ListViolationEventsPaginated, request)
          def describeThingGroup(request: DescribeThingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly
          ] = proxy(DescribeThingGroup, request)
          def listTopicRules(request: ListTopicRulesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.TopicRuleListItem.ReadOnly
          ] = rts.unsafeRun(proxy(ListTopicRules, request))
          def listTopicRulesPaginated(
              request: ListTopicRulesRequest
          ): IO[AwsError, zio.aws.iot.model.ListTopicRulesResponse.ReadOnly] =
            proxy(ListTopicRulesPaginated, request)
          def listPolicyVersions(request: ListPolicyVersionsRequest): IO[
            AwsError,
            zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly
          ] = proxy(ListPolicyVersions, request)
          def updateAuthorizer(
              request: UpdateAuthorizerRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly] =
            proxy(UpdateAuthorizer, request)
          def createDomainConfiguration(
              request: CreateDomainConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly
          ] = proxy(CreateDomainConfiguration, request)
          def getOTAUpdate(
              request: GetOtaUpdateRequest
          ): IO[AwsError, zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly] =
            proxy(GetOTAUpdate, request)
          def registerCertificateWithoutCA(
              request: RegisterCertificateWithoutCaRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly
          ] = proxy(RegisterCertificateWithoutCA, request)
          def rejectCertificateTransfer(
              request: RejectCertificateTransferRequest
          ): IO[AwsError, Unit] = proxy(RejectCertificateTransfer, request)
          def describeAuditFinding(request: DescribeAuditFindingRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly
          ] = proxy(DescribeAuditFinding, request)
          def startOnDemandAuditTask(
              request: StartOnDemandAuditTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly
          ] = proxy(StartOnDemandAuditTask, request)
          def deleteSecurityProfile(request: DeleteSecurityProfileRequest): IO[
            AwsError,
            zio.aws.iot.model.DeleteSecurityProfileResponse.ReadOnly
          ] = proxy(DeleteSecurityProfile, request)
          def listAuditMitigationActionsExecutions(
              request: ListAuditMitigationActionsExecutionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
          ] =
            rts.unsafeRun(proxy(ListAuditMitigationActionsExecutions, request))
          def listAuditMitigationActionsExecutionsPaginated(
              request: ListAuditMitigationActionsExecutionsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly
          ] = proxy(ListAuditMitigationActionsExecutionsPaginated, request)
          def getTopicRuleDestination(
              request: GetTopicRuleDestinationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly
          ] = proxy(GetTopicRuleDestination, request)
          def listThingGroups(request: ListThingGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.GroupNameAndArn.ReadOnly
          ] = rts.unsafeRun(proxy(ListThingGroups, request))
          def listThingGroupsPaginated(
              request: ListThingGroupsRequest
          ): IO[AwsError, zio.aws.iot.model.ListThingGroupsResponse.ReadOnly] =
            proxy(ListThingGroupsPaginated, request)
          def deleteCertificate(
              request: DeleteCertificateRequest
          ): IO[AwsError, Unit] = proxy(DeleteCertificate, request)
          def describeJobTemplate(request: DescribeJobTemplateRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly
          ] = proxy(DescribeJobTemplate, request)
          def deleteFleetMetric(
              request: DeleteFleetMetricRequest
          ): IO[AwsError, Unit] = proxy(DeleteFleetMetric, request)
          def setDefaultPolicyVersion(
              request: SetDefaultPolicyVersionRequest
          ): IO[AwsError, Unit] = proxy(SetDefaultPolicyVersion, request)
          def deleteCACertificate(request: DeleteCaCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.DeleteCaCertificateResponse.ReadOnly
          ] = proxy(DeleteCACertificate, request)
          def deleteV2LoggingLevel(
              request: DeleteV2LoggingLevelRequest
          ): IO[AwsError, Unit] = proxy(DeleteV2LoggingLevel, request)
          def listAuditFindings(
              request: ListAuditFindingsRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.AuditFinding.ReadOnly] =
            rts.unsafeRun(proxy(ListAuditFindings, request))
          def listAuditFindingsPaginated(request: ListAuditFindingsRequest): IO[
            AwsError,
            zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly
          ] = proxy(ListAuditFindingsPaginated, request)
          def validateSecurityProfileBehaviors(
              request: ValidateSecurityProfileBehaviorsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly
          ] = proxy(ValidateSecurityProfileBehaviors, request)
          def listRoleAliases(
              request: ListRoleAliasesRequest
          ): ZStream[Any, AwsError, RoleAlias] =
            rts.unsafeRun(proxy(ListRoleAliases, request))
          def listRoleAliasesPaginated(
              request: ListRoleAliasesRequest
          ): IO[AwsError, zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly] =
            proxy(ListRoleAliasesPaginated, request)
          def listCertificatesByCA(
              request: ListCertificatesByCaRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly] =
            rts.unsafeRun(proxy(ListCertificatesByCA, request))
          def listCertificatesByCAPaginated(
              request: ListCertificatesByCaRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListCertificatesByCaResponse.ReadOnly
          ] = proxy(ListCertificatesByCAPaginated, request)
          def updateAccountAuditConfiguration(
              request: UpdateAccountAuditConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.ReadOnly
          ] = proxy(UpdateAccountAuditConfiguration, request)
          def describeSecurityProfile(
              request: DescribeSecurityProfileRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly
          ] = proxy(DescribeSecurityProfile, request)
          def listAuthorizers(request: ListAuthorizersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.AuthorizerSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAuthorizers, request))
          def listAuthorizersPaginated(
              request: ListAuthorizersRequest
          ): IO[AwsError, zio.aws.iot.model.ListAuthorizersResponse.ReadOnly] =
            proxy(ListAuthorizersPaginated, request)
          def deleteStream(
              request: DeleteStreamRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteStreamResponse.ReadOnly] =
            proxy(DeleteStream, request)
          def deleteOTAUpdate(
              request: DeleteOtaUpdateRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteOtaUpdateResponse.ReadOnly] =
            proxy(DeleteOTAUpdate, request)
          def updateMitigationAction(
              request: UpdateMitigationActionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly
          ] = proxy(UpdateMitigationAction, request)
          def clearDefaultAuthorizer(
              request: ClearDefaultAuthorizerRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ClearDefaultAuthorizerResponse.ReadOnly
          ] = proxy(ClearDefaultAuthorizer, request)
          def deleteScheduledAudit(request: DeleteScheduledAuditRequest): IO[
            AwsError,
            zio.aws.iot.model.DeleteScheduledAuditResponse.ReadOnly
          ] = proxy(DeleteScheduledAudit, request)
          def listPolicies(
              request: ListPoliciesRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
            rts.unsafeRun(proxy(ListPolicies, request))
          def listPoliciesPaginated(
              request: ListPoliciesRequest
          ): IO[AwsError, zio.aws.iot.model.ListPoliciesResponse.ReadOnly] =
            proxy(ListPoliciesPaginated, request)
          def describeProvisioningTemplateVersion(
              request: DescribeProvisioningTemplateVersionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly
          ] = proxy(DescribeProvisioningTemplateVersion, request)
          def listCustomMetrics(
              request: ListCustomMetricsRequest
          ): ZStream[Any, AwsError, MetricName] =
            rts.unsafeRun(proxy(ListCustomMetrics, request))
          def listCustomMetricsPaginated(request: ListCustomMetricsRequest): IO[
            AwsError,
            zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly
          ] = proxy(ListCustomMetricsPaginated, request)
          def listOTAUpdates(request: ListOtaUpdatesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.OTAUpdateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListOTAUpdates, request))
          def listOTAUpdatesPaginated(
              request: ListOtaUpdatesRequest
          ): IO[AwsError, zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly] =
            proxy(ListOTAUpdatesPaginated, request)
          def replaceTopicRule(
              request: ReplaceTopicRuleRequest
          ): IO[AwsError, Unit] = proxy(ReplaceTopicRule, request)
          def getV2LoggingOptions(request: GetV2LoggingOptionsRequest): IO[
            AwsError,
            zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly
          ] = proxy(GetV2LoggingOptions, request)
          def describeStream(
              request: DescribeStreamRequest
          ): IO[AwsError, zio.aws.iot.model.DescribeStreamResponse.ReadOnly] =
            proxy(DescribeStream, request)
          def listMitigationActions(
              request: ListMitigationActionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
          ] = rts.unsafeRun(proxy(ListMitigationActions, request))
          def listMitigationActionsPaginated(
              request: ListMitigationActionsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly
          ] = proxy(ListMitigationActionsPaginated, request)
          def cancelCertificateTransfer(
              request: CancelCertificateTransferRequest
          ): IO[AwsError, Unit] = proxy(CancelCertificateTransfer, request)
          def createStream(
              request: CreateStreamRequest
          ): IO[AwsError, zio.aws.iot.model.CreateStreamResponse.ReadOnly] =
            proxy(CreateStream, request)
          def acceptCertificateTransfer(
              request: AcceptCertificateTransferRequest
          ): IO[AwsError, Unit] = proxy(AcceptCertificateTransfer, request)
          def listDetectMitigationActionsExecutions(
              request: ListDetectMitigationActionsExecutionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
          ] =
            rts.unsafeRun(proxy(ListDetectMitigationActionsExecutions, request))
          def listDetectMitigationActionsExecutionsPaginated(
              request: ListDetectMitigationActionsExecutionsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly
          ] = proxy(ListDetectMitigationActionsExecutionsPaginated, request)
          def createTopicRule(
              request: CreateTopicRuleRequest
          ): IO[AwsError, Unit] = proxy(CreateTopicRule, request)
          def deletePolicyVersion(
              request: DeletePolicyVersionRequest
          ): IO[AwsError, Unit] = proxy(DeletePolicyVersion, request)
          def listTopicRuleDestinations(
              request: ListTopicRuleDestinationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListTopicRuleDestinations, request))
          def listTopicRuleDestinationsPaginated(
              request: ListTopicRuleDestinationsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly
          ] = proxy(ListTopicRuleDestinationsPaginated, request)
          def searchIndex(
              request: SearchIndexRequest
          ): IO[AwsError, zio.aws.iot.model.SearchIndexResponse.ReadOnly] =
            proxy(SearchIndex, request)
          def attachSecurityProfile(request: AttachSecurityProfileRequest): IO[
            AwsError,
            zio.aws.iot.model.AttachSecurityProfileResponse.ReadOnly
          ] = proxy(AttachSecurityProfile, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.iot.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def updateCertificate(
              request: UpdateCertificateRequest
          ): IO[AwsError, Unit] = proxy(UpdateCertificate, request)
          def createFleetMetric(request: CreateFleetMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly
          ] = proxy(CreateFleetMetric, request)
          def describeEndpoint(
              request: DescribeEndpointRequest
          ): IO[AwsError, zio.aws.iot.model.DescribeEndpointResponse.ReadOnly] =
            proxy(DescribeEndpoint, request)
          def updateProvisioningTemplate(
              request: UpdateProvisioningTemplateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateProvisioningTemplateResponse.ReadOnly
          ] = proxy(UpdateProvisioningTemplate, request)
          def listSecurityProfiles(
              request: ListSecurityProfilesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
          ] = rts.unsafeRun(proxy(ListSecurityProfiles, request))
          def listSecurityProfilesPaginated(
              request: ListSecurityProfilesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly
          ] = proxy(ListSecurityProfilesPaginated, request)
          def deleteTopicRuleDestination(
              request: DeleteTopicRuleDestinationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteTopicRuleDestinationResponse.ReadOnly
          ] = proxy(DeleteTopicRuleDestination, request)
          def createCertificateFromCsr(
              request: CreateCertificateFromCsrRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly
          ] = proxy(CreateCertificateFromCsr, request)
          def createRoleAlias(
              request: CreateRoleAliasRequest
          ): IO[AwsError, zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly] =
            proxy(CreateRoleAlias, request)
          def registerCACertificate(request: RegisterCaCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly
          ] = proxy(RegisterCACertificate, request)
          def setV2LoggingOptions(
              request: SetV2LoggingOptionsRequest
          ): IO[AwsError, Unit] = proxy(SetV2LoggingOptions, request)
          def getStatistics(
              request: GetStatisticsRequest
          ): IO[AwsError, zio.aws.iot.model.GetStatisticsResponse.ReadOnly] =
            proxy(GetStatistics, request)
          def listDimensions(
              request: ListDimensionsRequest
          ): ZStream[Any, AwsError, DimensionName] =
            rts.unsafeRun(proxy(ListDimensions, request))
          def listDimensionsPaginated(
              request: ListDimensionsRequest
          ): IO[AwsError, zio.aws.iot.model.ListDimensionsResponse.ReadOnly] =
            proxy(ListDimensionsPaginated, request)
          def createThingGroup(
              request: CreateThingGroupRequest
          ): IO[AwsError, zio.aws.iot.model.CreateThingGroupResponse.ReadOnly] =
            proxy(CreateThingGroup, request)
          def listDetectMitigationActionsTasks(
              request: ListDetectMitigationActionsTasksRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDetectMitigationActionsTasks, request))
          def listDetectMitigationActionsTasksPaginated(
              request: ListDetectMitigationActionsTasksRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.ReadOnly
          ] = proxy(ListDetectMitigationActionsTasksPaginated, request)
          def updateFleetMetric(
              request: UpdateFleetMetricRequest
          ): IO[AwsError, Unit] = proxy(UpdateFleetMetric, request)
          def deleteTopicRule(
              request: DeleteTopicRuleRequest
          ): IO[AwsError, Unit] = proxy(DeleteTopicRule, request)
          def createMitigationAction(
              request: CreateMitigationActionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateMitigationActionResponse.ReadOnly
          ] = proxy(CreateMitigationAction, request)
          def describeCustomMetric(request: DescribeCustomMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly
          ] = proxy(DescribeCustomMetric, request)
          def describeDetectMitigationActionsTask(
              request: DescribeDetectMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly
          ] = proxy(DescribeDetectMitigationActionsTask, request)
          def listBillingGroups(request: ListBillingGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.GroupNameAndArn.ReadOnly
          ] = rts.unsafeRun(proxy(ListBillingGroups, request))
          def listBillingGroupsPaginated(request: ListBillingGroupsRequest): IO[
            AwsError,
            zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly
          ] = proxy(ListBillingGroupsPaginated, request)
          def updateJob(request: UpdateJobRequest): IO[AwsError, Unit] =
            proxy(UpdateJob, request)
          def createAuthorizer(
              request: CreateAuthorizerRequest
          ): IO[AwsError, zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly] =
            proxy(CreateAuthorizer, request)
          def setDefaultAuthorizer(request: SetDefaultAuthorizerRequest): IO[
            AwsError,
            zio.aws.iot.model.SetDefaultAuthorizerResponse.ReadOnly
          ] = proxy(SetDefaultAuthorizer, request)
          def deleteRoleAlias(
              request: DeleteRoleAliasRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteRoleAliasResponse.ReadOnly] =
            proxy(DeleteRoleAlias, request)
          def attachPolicy(request: AttachPolicyRequest): IO[AwsError, Unit] =
            proxy(AttachPolicy, request)
          def listThingRegistrationTasks(
              request: ListThingRegistrationTasksRequest
          ): ZStream[Any, AwsError, TaskId] =
            rts.unsafeRun(proxy(ListThingRegistrationTasks, request))
          def listThingRegistrationTasksPaginated(
              request: ListThingRegistrationTasksRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly
          ] = proxy(ListThingRegistrationTasksPaginated, request)
          def describeAuditSuppression(
              request: DescribeAuditSuppressionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly
          ] = proxy(DescribeAuditSuppression, request)
          def listThingPrincipals(
              request: ListThingPrincipalsRequest
          ): ZStream[Any, AwsError, PrincipalArn] =
            rts.unsafeRun(proxy(ListThingPrincipals, request))
          def listThingPrincipalsPaginated(
              request: ListThingPrincipalsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly
          ] = proxy(ListThingPrincipalsPaginated, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTagsForResource, request))
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def deleteThing(
              request: DeleteThingRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteThingResponse.ReadOnly] =
            proxy(DeleteThing, request)
          def listAuditMitigationActionsTasks(
              request: ListAuditMitigationActionsTasksRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListAuditMitigationActionsTasks, request))
          def listAuditMitigationActionsTasksPaginated(
              request: ListAuditMitigationActionsTasksRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.ReadOnly
          ] = proxy(ListAuditMitigationActionsTasksPaginated, request)
          def listJobs(
              request: ListJobsRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.JobSummary.ReadOnly] =
            rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.iot.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def createCustomMetric(request: CreateCustomMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly
          ] = proxy(CreateCustomMetric, request)
          def createPolicy(
              request: CreatePolicyRequest
          ): IO[AwsError, zio.aws.iot.model.CreatePolicyResponse.ReadOnly] =
            proxy(CreatePolicy, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.iot.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def enableTopicRule(
              request: EnableTopicRuleRequest
          ): IO[AwsError, Unit] = proxy(EnableTopicRule, request)
          def deleteThingType(
              request: DeleteThingTypeRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteThingTypeResponse.ReadOnly] =
            proxy(DeleteThingType, request)
          def listManagedJobTemplates(
              request: ListManagedJobTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly
          ] = proxy(ListManagedJobTemplates, request)
          def listThingsInThingGroup(
              request: ListThingsInThingGroupRequest
          ): ZStream[Any, AwsError, ThingName] =
            rts.unsafeRun(proxy(ListThingsInThingGroup, request))
          def listThingsInThingGroupPaginated(
              request: ListThingsInThingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingsInThingGroupResponse.ReadOnly
          ] = proxy(ListThingsInThingGroupPaginated, request)
          def getTopicRule(
              request: GetTopicRuleRequest
          ): IO[AwsError, zio.aws.iot.model.GetTopicRuleResponse.ReadOnly] =
            proxy(GetTopicRule, request)
          def listScheduledAudits(request: ListScheduledAuditsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListScheduledAudits, request))
          def listScheduledAuditsPaginated(
              request: ListScheduledAuditsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly
          ] = proxy(ListScheduledAuditsPaginated, request)
          def startThingRegistrationTask(
              request: StartThingRegistrationTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly
          ] = proxy(StartThingRegistrationTask, request)
          def listV2LoggingLevels(request: ListV2LoggingLevelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.LogTargetConfiguration.ReadOnly
          ] = rts.unsafeRun(proxy(ListV2LoggingLevels, request))
          def listV2LoggingLevelsPaginated(
              request: ListV2LoggingLevelsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly
          ] = proxy(ListV2LoggingLevelsPaginated, request)
          def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit] =
            proxy(DeletePolicy, request)
          def deleteAuthorizer(
              request: DeleteAuthorizerRequest
          ): IO[AwsError, zio.aws.iot.model.DeleteAuthorizerResponse.ReadOnly] =
            proxy(DeleteAuthorizer, request)
          def getPolicy(
              request: GetPolicyRequest
          ): IO[AwsError, zio.aws.iot.model.GetPolicyResponse.ReadOnly] =
            proxy(GetPolicy, request)
          def startAuditMitigationActionsTask(
              request: StartAuditMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly
          ] = proxy(StartAuditMitigationActionsTask, request)
          def transferCertificate(request: TransferCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.TransferCertificateResponse.ReadOnly
          ] = proxy(TransferCertificate, request)
          def addThingToThingGroup(request: AddThingToThingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.AddThingToThingGroupResponse.ReadOnly
          ] = proxy(AddThingToThingGroup, request)
          def startDetectMitigationActionsTask(
              request: StartDetectMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly
          ] = proxy(StartDetectMitigationActionsTask, request)
          def associateTargetsWithJob(
              request: AssociateTargetsWithJobRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly
          ] = proxy(AssociateTargetsWithJob, request)
          def describeEventConfigurations(
              request: DescribeEventConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly
          ] = proxy(DescribeEventConfigurations, request)
          def describeThingType(request: DescribeThingTypeRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly
          ] = proxy(DescribeThingType, request)
          def listJobExecutionsForThing(
              request: ListJobExecutionsForThingRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobExecutionsForThing, request))
          def listJobExecutionsForThingPaginated(
              request: ListJobExecutionsForThingRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly
          ] = proxy(ListJobExecutionsForThingPaginated, request)
          def updateRoleAlias(
              request: UpdateRoleAliasRequest
          ): IO[AwsError, zio.aws.iot.model.UpdateRoleAliasResponse.ReadOnly] =
            proxy(UpdateRoleAlias, request)
          def listProvisioningTemplates(
              request: ListProvisioningTemplatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListProvisioningTemplates, request))
          def listProvisioningTemplatesPaginated(
              request: ListProvisioningTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly
          ] = proxy(ListProvisioningTemplatesPaginated, request)
          def listThingTypes(request: ListThingTypesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.ThingTypeDefinition.ReadOnly
          ] = rts.unsafeRun(proxy(ListThingTypes, request))
          def listThingTypesPaginated(
              request: ListThingTypesRequest
          ): IO[AwsError, zio.aws.iot.model.ListThingTypesResponse.ReadOnly] =
            proxy(ListThingTypesPaginated, request)
          def disableTopicRule(
              request: DisableTopicRuleRequest
          ): IO[AwsError, Unit] = proxy(DisableTopicRule, request)
          def registerCertificate(request: RegisterCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.RegisterCertificateResponse.ReadOnly
          ] = proxy(RegisterCertificate, request)
          def describeDimension(request: DescribeDimensionRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeDimensionResponse.ReadOnly
          ] = proxy(DescribeDimension, request)
          def createPolicyVersion(request: CreatePolicyVersionRequest): IO[
            AwsError,
            zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly
          ] = proxy(CreatePolicyVersion, request)
          def deleteRegistrationCode(
              request: DeleteRegistrationCodeRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteRegistrationCodeResponse.ReadOnly
          ] = proxy(DeleteRegistrationCode, request)
          def describeBillingGroup(request: DescribeBillingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly
          ] = proxy(DescribeBillingGroup, request)
          def updateSecurityProfile(request: UpdateSecurityProfileRequest): IO[
            AwsError,
            zio.aws.iot.model.UpdateSecurityProfileResponse.ReadOnly
          ] = proxy(UpdateSecurityProfile, request)
          def updateTopicRuleDestination(
              request: UpdateTopicRuleDestinationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateTopicRuleDestinationResponse.ReadOnly
          ] = proxy(UpdateTopicRuleDestination, request)
          def updateBillingGroup(request: UpdateBillingGroupRequest): IO[
            AwsError,
            zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly
          ] = proxy(UpdateBillingGroup, request)
          def getEffectivePolicies(request: GetEffectivePoliciesRequest): IO[
            AwsError,
            zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly
          ] = proxy(GetEffectivePolicies, request)
          def listAuditTasks(request: ListAuditTasksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.AuditTaskMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListAuditTasks, request))
          def listAuditTasksPaginated(
              request: ListAuditTasksRequest
          ): IO[AwsError, zio.aws.iot.model.ListAuditTasksResponse.ReadOnly] =
            proxy(ListAuditTasksPaginated, request)
          def describeCertificate(request: DescribeCertificateRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeCertificateResponse.ReadOnly
          ] = proxy(DescribeCertificate, request)
          def describeAuditMitigationActionsTask(
              request: DescribeAuditMitigationActionsTaskRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly
          ] = proxy(DescribeAuditMitigationActionsTask, request)
          def createThingType(
              request: CreateThingTypeRequest
          ): IO[AwsError, zio.aws.iot.model.CreateThingTypeResponse.ReadOnly] =
            proxy(CreateThingType, request)
          def createAuditSuppression(
              request: CreateAuditSuppressionRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.CreateAuditSuppressionResponse.ReadOnly
          ] = proxy(CreateAuditSuppression, request)
          def getLoggingOptions(request: GetLoggingOptionsRequest): IO[
            AwsError,
            zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly
          ] = proxy(GetLoggingOptions, request)
          def listThingGroupsForThing(
              request: ListThingGroupsForThingRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.GroupNameAndArn.ReadOnly
          ] = rts.unsafeRun(proxy(ListThingGroupsForThing, request))
          def listThingGroupsForThingPaginated(
              request: ListThingGroupsForThingRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingGroupsForThingResponse.ReadOnly
          ] = proxy(ListThingGroupsForThingPaginated, request)
          def getBucketsAggregation(request: GetBucketsAggregationRequest): IO[
            AwsError,
            zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly
          ] = proxy(GetBucketsAggregation, request)
          def removeThingFromBillingGroup(
              request: RemoveThingFromBillingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.RemoveThingFromBillingGroupResponse.ReadOnly
          ] = proxy(RemoveThingFromBillingGroup, request)
          def listCertificates(
              request: ListCertificatesRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly] =
            rts.unsafeRun(proxy(ListCertificates, request))
          def listCertificatesPaginated(
              request: ListCertificatesRequest
          ): IO[AwsError, zio.aws.iot.model.ListCertificatesResponse.ReadOnly] =
            proxy(ListCertificatesPaginated, request)
          def getPolicyVersion(
              request: GetPolicyVersionRequest
          ): IO[AwsError, zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly] =
            proxy(GetPolicyVersion, request)
          def describeRoleAlias(request: DescribeRoleAliasRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly
          ] = proxy(DescribeRoleAlias, request)
          def deleteProvisioningTemplate(
              request: DeleteProvisioningTemplateRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteProvisioningTemplateResponse.ReadOnly
          ] = proxy(DeleteProvisioningTemplate, request)
          def updateDynamicThingGroup(
              request: UpdateDynamicThingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly
          ] = proxy(UpdateDynamicThingGroup, request)
          def createDimension(
              request: CreateDimensionRequest
          ): IO[AwsError, zio.aws.iot.model.CreateDimensionResponse.ReadOnly] =
            proxy(CreateDimension, request)
          def deprecateThingType(request: DeprecateThingTypeRequest): IO[
            AwsError,
            zio.aws.iot.model.DeprecateThingTypeResponse.ReadOnly
          ] = proxy(DeprecateThingType, request)
          def addThingToBillingGroup(
              request: AddThingToBillingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.AddThingToBillingGroupResponse.ReadOnly
          ] = proxy(AddThingToBillingGroup, request)
          def describeDefaultAuthorizer(
              request: DescribeDefaultAuthorizerRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly
          ] = proxy(DescribeDefaultAuthorizer, request)
          def testAuthorization(request: TestAuthorizationRequest): IO[
            AwsError,
            zio.aws.iot.model.TestAuthorizationResponse.ReadOnly
          ] = proxy(TestAuthorization, request)
          def listOutgoingCertificates(
              request: ListOutgoingCertificatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.OutgoingCertificate.ReadOnly
          ] = rts.unsafeRun(proxy(ListOutgoingCertificates, request))
          def listOutgoingCertificatesPaginated(
              request: ListOutgoingCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly
          ] = proxy(ListOutgoingCertificatesPaginated, request)
          def confirmTopicRuleDestination(
              request: ConfirmTopicRuleDestinationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.ReadOnly
          ] = proxy(ConfirmTopicRuleDestination, request)
          def deleteAccountAuditConfiguration(
              request: DeleteAccountAuditConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.ReadOnly
          ] = proxy(DeleteAccountAuditConfiguration, request)
          def describeFleetMetric(request: DescribeFleetMetricRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly
          ] = proxy(DescribeFleetMetric, request)
          def listThings(
              request: ListThingsRequest
          ): ZStream[Any, AwsError, zio.aws.iot.model.ThingAttribute.ReadOnly] =
            rts.unsafeRun(proxy(ListThings, request))
          def listThingsPaginated(
              request: ListThingsRequest
          ): IO[AwsError, zio.aws.iot.model.ListThingsResponse.ReadOnly] =
            proxy(ListThingsPaginated, request)
          def describeAuditTask(request: DescribeAuditTaskRequest): IO[
            AwsError,
            zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly
          ] = proxy(DescribeAuditTask, request)
          def updateEventConfigurations(
              request: UpdateEventConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.UpdateEventConfigurationsResponse.ReadOnly
          ] = proxy(UpdateEventConfigurations, request)
          def deleteJob(request: DeleteJobRequest): IO[AwsError, Unit] =
            proxy(DeleteJob, request)
          def listThingRegistrationTaskReports(
              request: ListThingRegistrationTaskReportsRequest
          ): ZStream[Any, AwsError, S3FileUrl] =
            rts.unsafeRun(proxy(ListThingRegistrationTaskReports, request))
          def listThingRegistrationTaskReportsPaginated(
              request: ListThingRegistrationTaskReportsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly
          ] = proxy(ListThingRegistrationTaskReportsPaginated, request)
          def createJobTemplate(request: CreateJobTemplateRequest): IO[
            AwsError,
            zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly
          ] = proxy(CreateJobTemplate, request)
          def listFleetMetrics(request: ListFleetMetricsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly
          ] = rts.unsafeRun(proxy(ListFleetMetrics, request))
          def listFleetMetricsPaginated(
              request: ListFleetMetricsRequest
          ): IO[AwsError, zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly] =
            proxy(ListFleetMetricsPaginated, request)
          def listActiveViolations(
              request: ListActiveViolationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iot.model.ActiveViolation.ReadOnly
          ] = rts.unsafeRun(proxy(ListActiveViolations, request))
          def listActiveViolationsPaginated(
              request: ListActiveViolationsRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly
          ] = proxy(ListActiveViolationsPaginated, request)
          def cancelAuditTask(
              request: CancelAuditTaskRequest
          ): IO[AwsError, zio.aws.iot.model.CancelAuditTaskResponse.ReadOnly] =
            proxy(CancelAuditTask, request)
          def deleteDynamicThingGroup(
              request: DeleteDynamicThingGroupRequest
          ): IO[
            AwsError,
            zio.aws.iot.model.DeleteDynamicThingGroupResponse.ReadOnly
          ] = proxy(DeleteDynamicThingGroup, request)
          def detachSecurityProfile(request: DetachSecurityProfileRequest): IO[
            AwsError,
            zio.aws.iot.model.DetachSecurityProfileResponse.ReadOnly
          ] = proxy(DetachSecurityProfile, request)
          def createThing(
              request: CreateThingRequest
          ): IO[AwsError, zio.aws.iot.model.CreateThingResponse.ReadOnly] =
            proxy(CreateThing, request)
        }
      }
    }
    .toLayer
}
