package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Action(
    dynamoDB: Option[zio.aws.iot.model.DynamoDBAction] = None,
    dynamoDBv2: Option[zio.aws.iot.model.DynamoDBv2Action] = None,
    lambda: Option[zio.aws.iot.model.LambdaAction] = None,
    sns: Option[zio.aws.iot.model.SnsAction] = None,
    sqs: Option[zio.aws.iot.model.SqsAction] = None,
    kinesis: Option[zio.aws.iot.model.KinesisAction] = None,
    republish: Option[zio.aws.iot.model.RepublishAction] = None,
    s3: Option[zio.aws.iot.model.S3Action] = None,
    firehose: Option[zio.aws.iot.model.FirehoseAction] = None,
    cloudwatchMetric: Option[zio.aws.iot.model.CloudwatchMetricAction] = None,
    cloudwatchAlarm: Option[zio.aws.iot.model.CloudwatchAlarmAction] = None,
    cloudwatchLogs: Option[zio.aws.iot.model.CloudwatchLogsAction] = None,
    elasticsearch: Option[zio.aws.iot.model.ElasticsearchAction] = None,
    salesforce: Option[zio.aws.iot.model.SalesforceAction] = None,
    iotAnalytics: Option[zio.aws.iot.model.IotAnalyticsAction] = None,
    iotEvents: Option[zio.aws.iot.model.IotEventsAction] = None,
    iotSiteWise: Option[zio.aws.iot.model.IotSiteWiseAction] = None,
    stepFunctions: Option[zio.aws.iot.model.StepFunctionsAction] = None,
    timestream: Option[zio.aws.iot.model.TimestreamAction] = None,
    http: Option[zio.aws.iot.model.HttpAction] = None,
    kafka: Option[zio.aws.iot.model.KafkaAction] = None,
    openSearch: Option[zio.aws.iot.model.OpenSearchAction] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Action
      .builder()
      .optionallyWith(dynamoDB.map(value => value.buildAwsValue()))(_.dynamoDB)
      .optionallyWith(dynamoDBv2.map(value => value.buildAwsValue()))(
        _.dynamoDBv2
      )
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(sns.map(value => value.buildAwsValue()))(_.sns)
      .optionallyWith(sqs.map(value => value.buildAwsValue()))(_.sqs)
      .optionallyWith(kinesis.map(value => value.buildAwsValue()))(_.kinesis)
      .optionallyWith(republish.map(value => value.buildAwsValue()))(
        _.republish
      )
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(cloudwatchMetric.map(value => value.buildAwsValue()))(
        _.cloudwatchMetric
      )
      .optionallyWith(cloudwatchAlarm.map(value => value.buildAwsValue()))(
        _.cloudwatchAlarm
      )
      .optionallyWith(cloudwatchLogs.map(value => value.buildAwsValue()))(
        _.cloudwatchLogs
      )
      .optionallyWith(elasticsearch.map(value => value.buildAwsValue()))(
        _.elasticsearch
      )
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(iotAnalytics.map(value => value.buildAwsValue()))(
        _.iotAnalytics
      )
      .optionallyWith(iotEvents.map(value => value.buildAwsValue()))(
        _.iotEvents
      )
      .optionallyWith(iotSiteWise.map(value => value.buildAwsValue()))(
        _.iotSiteWise
      )
      .optionallyWith(stepFunctions.map(value => value.buildAwsValue()))(
        _.stepFunctions
      )
      .optionallyWith(timestream.map(value => value.buildAwsValue()))(
        _.timestream
      )
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(kafka.map(value => value.buildAwsValue()))(_.kafka)
      .optionallyWith(openSearch.map(value => value.buildAwsValue()))(
        _.openSearch
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Action.ReadOnly =
    zio.aws.iot.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Action = zio.aws.iot.model.Action(
      dynamoDB.map(value => value.asEditable),
      dynamoDBv2.map(value => value.asEditable),
      lambda.map(value => value.asEditable),
      sns.map(value => value.asEditable),
      sqs.map(value => value.asEditable),
      kinesis.map(value => value.asEditable),
      republish.map(value => value.asEditable),
      s3.map(value => value.asEditable),
      firehose.map(value => value.asEditable),
      cloudwatchMetric.map(value => value.asEditable),
      cloudwatchAlarm.map(value => value.asEditable),
      cloudwatchLogs.map(value => value.asEditable),
      elasticsearch.map(value => value.asEditable),
      salesforce.map(value => value.asEditable),
      iotAnalytics.map(value => value.asEditable),
      iotEvents.map(value => value.asEditable),
      iotSiteWise.map(value => value.asEditable),
      stepFunctions.map(value => value.asEditable),
      timestream.map(value => value.asEditable),
      http.map(value => value.asEditable),
      kafka.map(value => value.asEditable),
      openSearch.map(value => value.asEditable)
    )
    def dynamoDB: Option[zio.aws.iot.model.DynamoDBAction.ReadOnly]
    def dynamoDBv2: Option[zio.aws.iot.model.DynamoDBv2Action.ReadOnly]
    def lambda: Option[zio.aws.iot.model.LambdaAction.ReadOnly]
    def sns: Option[zio.aws.iot.model.SnsAction.ReadOnly]
    def sqs: Option[zio.aws.iot.model.SqsAction.ReadOnly]
    def kinesis: Option[zio.aws.iot.model.KinesisAction.ReadOnly]
    def republish: Option[zio.aws.iot.model.RepublishAction.ReadOnly]
    def s3: Option[zio.aws.iot.model.S3Action.ReadOnly]
    def firehose: Option[zio.aws.iot.model.FirehoseAction.ReadOnly]
    def cloudwatchMetric
        : Option[zio.aws.iot.model.CloudwatchMetricAction.ReadOnly]
    def cloudwatchAlarm
        : Option[zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly]
    def cloudwatchLogs: Option[zio.aws.iot.model.CloudwatchLogsAction.ReadOnly]
    def elasticsearch: Option[zio.aws.iot.model.ElasticsearchAction.ReadOnly]
    def salesforce: Option[zio.aws.iot.model.SalesforceAction.ReadOnly]
    def iotAnalytics: Option[zio.aws.iot.model.IotAnalyticsAction.ReadOnly]
    def iotEvents: Option[zio.aws.iot.model.IotEventsAction.ReadOnly]
    def iotSiteWise: Option[zio.aws.iot.model.IotSiteWiseAction.ReadOnly]
    def stepFunctions: Option[zio.aws.iot.model.StepFunctionsAction.ReadOnly]
    def timestream: Option[zio.aws.iot.model.TimestreamAction.ReadOnly]
    def http: Option[zio.aws.iot.model.HttpAction.ReadOnly]
    def kafka: Option[zio.aws.iot.model.KafkaAction.ReadOnly]
    def openSearch: Option[zio.aws.iot.model.OpenSearchAction.ReadOnly]
    def getDynamoDB
        : ZIO[Any, AwsError, zio.aws.iot.model.DynamoDBAction.ReadOnly] =
      AwsError.unwrapOptionField("dynamoDB", dynamoDB)
    def getDynamoDBv2
        : ZIO[Any, AwsError, zio.aws.iot.model.DynamoDBv2Action.ReadOnly] =
      AwsError.unwrapOptionField("dynamoDBv2", dynamoDBv2)
    def getLambda: ZIO[Any, AwsError, zio.aws.iot.model.LambdaAction.ReadOnly] =
      AwsError.unwrapOptionField("lambda", lambda)
    def getSns: ZIO[Any, AwsError, zio.aws.iot.model.SnsAction.ReadOnly] =
      AwsError.unwrapOptionField("sns", sns)
    def getSqs: ZIO[Any, AwsError, zio.aws.iot.model.SqsAction.ReadOnly] =
      AwsError.unwrapOptionField("sqs", sqs)
    def getKinesis
        : ZIO[Any, AwsError, zio.aws.iot.model.KinesisAction.ReadOnly] =
      AwsError.unwrapOptionField("kinesis", kinesis)
    def getRepublish
        : ZIO[Any, AwsError, zio.aws.iot.model.RepublishAction.ReadOnly] =
      AwsError.unwrapOptionField("republish", republish)
    def getS3: ZIO[Any, AwsError, zio.aws.iot.model.S3Action.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
    def getFirehose
        : ZIO[Any, AwsError, zio.aws.iot.model.FirehoseAction.ReadOnly] =
      AwsError.unwrapOptionField("firehose", firehose)
    def getCloudwatchMetric: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CloudwatchMetricAction.ReadOnly
    ] = AwsError.unwrapOptionField("cloudwatchMetric", cloudwatchMetric)
    def getCloudwatchAlarm
        : ZIO[Any, AwsError, zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly] =
      AwsError.unwrapOptionField("cloudwatchAlarm", cloudwatchAlarm)
    def getCloudwatchLogs
        : ZIO[Any, AwsError, zio.aws.iot.model.CloudwatchLogsAction.ReadOnly] =
      AwsError.unwrapOptionField("cloudwatchLogs", cloudwatchLogs)
    def getElasticsearch
        : ZIO[Any, AwsError, zio.aws.iot.model.ElasticsearchAction.ReadOnly] =
      AwsError.unwrapOptionField("elasticsearch", elasticsearch)
    def getSalesforce
        : ZIO[Any, AwsError, zio.aws.iot.model.SalesforceAction.ReadOnly] =
      AwsError.unwrapOptionField("salesforce", salesforce)
    def getIotAnalytics
        : ZIO[Any, AwsError, zio.aws.iot.model.IotAnalyticsAction.ReadOnly] =
      AwsError.unwrapOptionField("iotAnalytics", iotAnalytics)
    def getIotEvents
        : ZIO[Any, AwsError, zio.aws.iot.model.IotEventsAction.ReadOnly] =
      AwsError.unwrapOptionField("iotEvents", iotEvents)
    def getIotSiteWise
        : ZIO[Any, AwsError, zio.aws.iot.model.IotSiteWiseAction.ReadOnly] =
      AwsError.unwrapOptionField("iotSiteWise", iotSiteWise)
    def getStepFunctions
        : ZIO[Any, AwsError, zio.aws.iot.model.StepFunctionsAction.ReadOnly] =
      AwsError.unwrapOptionField("stepFunctions", stepFunctions)
    def getTimestream
        : ZIO[Any, AwsError, zio.aws.iot.model.TimestreamAction.ReadOnly] =
      AwsError.unwrapOptionField("timestream", timestream)
    def getHttp: ZIO[Any, AwsError, zio.aws.iot.model.HttpAction.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getKafka: ZIO[Any, AwsError, zio.aws.iot.model.KafkaAction.ReadOnly] =
      AwsError.unwrapOptionField("kafka", kafka)
    def getOpenSearch
        : ZIO[Any, AwsError, zio.aws.iot.model.OpenSearchAction.ReadOnly] =
      AwsError.unwrapOptionField("openSearch", openSearch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Action
  ) extends zio.aws.iot.model.Action.ReadOnly {
    override val dynamoDB: Option[zio.aws.iot.model.DynamoDBAction.ReadOnly] =
      scala
        .Option(impl.dynamoDB())
        .map(value => zio.aws.iot.model.DynamoDBAction.wrap(value))
    override val dynamoDBv2
        : Option[zio.aws.iot.model.DynamoDBv2Action.ReadOnly] = scala
      .Option(impl.dynamoDBv2())
      .map(value => zio.aws.iot.model.DynamoDBv2Action.wrap(value))
    override val lambda: Option[zio.aws.iot.model.LambdaAction.ReadOnly] = scala
      .Option(impl.lambda())
      .map(value => zio.aws.iot.model.LambdaAction.wrap(value))
    override val sns: Option[zio.aws.iot.model.SnsAction.ReadOnly] = scala
      .Option(impl.sns())
      .map(value => zio.aws.iot.model.SnsAction.wrap(value))
    override val sqs: Option[zio.aws.iot.model.SqsAction.ReadOnly] = scala
      .Option(impl.sqs())
      .map(value => zio.aws.iot.model.SqsAction.wrap(value))
    override val kinesis: Option[zio.aws.iot.model.KinesisAction.ReadOnly] =
      scala
        .Option(impl.kinesis())
        .map(value => zio.aws.iot.model.KinesisAction.wrap(value))
    override val republish: Option[zio.aws.iot.model.RepublishAction.ReadOnly] =
      scala
        .Option(impl.republish())
        .map(value => zio.aws.iot.model.RepublishAction.wrap(value))
    override val s3: Option[zio.aws.iot.model.S3Action.ReadOnly] = scala
      .Option(impl.s3())
      .map(value => zio.aws.iot.model.S3Action.wrap(value))
    override val firehose: Option[zio.aws.iot.model.FirehoseAction.ReadOnly] =
      scala
        .Option(impl.firehose())
        .map(value => zio.aws.iot.model.FirehoseAction.wrap(value))
    override val cloudwatchMetric
        : Option[zio.aws.iot.model.CloudwatchMetricAction.ReadOnly] = scala
      .Option(impl.cloudwatchMetric())
      .map(value => zio.aws.iot.model.CloudwatchMetricAction.wrap(value))
    override val cloudwatchAlarm
        : Option[zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly] = scala
      .Option(impl.cloudwatchAlarm())
      .map(value => zio.aws.iot.model.CloudwatchAlarmAction.wrap(value))
    override val cloudwatchLogs
        : Option[zio.aws.iot.model.CloudwatchLogsAction.ReadOnly] = scala
      .Option(impl.cloudwatchLogs())
      .map(value => zio.aws.iot.model.CloudwatchLogsAction.wrap(value))
    override val elasticsearch
        : Option[zio.aws.iot.model.ElasticsearchAction.ReadOnly] = scala
      .Option(impl.elasticsearch())
      .map(value => zio.aws.iot.model.ElasticsearchAction.wrap(value))
    override val salesforce
        : Option[zio.aws.iot.model.SalesforceAction.ReadOnly] = scala
      .Option(impl.salesforce())
      .map(value => zio.aws.iot.model.SalesforceAction.wrap(value))
    override val iotAnalytics
        : Option[zio.aws.iot.model.IotAnalyticsAction.ReadOnly] = scala
      .Option(impl.iotAnalytics())
      .map(value => zio.aws.iot.model.IotAnalyticsAction.wrap(value))
    override val iotEvents: Option[zio.aws.iot.model.IotEventsAction.ReadOnly] =
      scala
        .Option(impl.iotEvents())
        .map(value => zio.aws.iot.model.IotEventsAction.wrap(value))
    override val iotSiteWise
        : Option[zio.aws.iot.model.IotSiteWiseAction.ReadOnly] = scala
      .Option(impl.iotSiteWise())
      .map(value => zio.aws.iot.model.IotSiteWiseAction.wrap(value))
    override val stepFunctions
        : Option[zio.aws.iot.model.StepFunctionsAction.ReadOnly] = scala
      .Option(impl.stepFunctions())
      .map(value => zio.aws.iot.model.StepFunctionsAction.wrap(value))
    override val timestream
        : Option[zio.aws.iot.model.TimestreamAction.ReadOnly] = scala
      .Option(impl.timestream())
      .map(value => zio.aws.iot.model.TimestreamAction.wrap(value))
    override val http: Option[zio.aws.iot.model.HttpAction.ReadOnly] = scala
      .Option(impl.http())
      .map(value => zio.aws.iot.model.HttpAction.wrap(value))
    override val kafka: Option[zio.aws.iot.model.KafkaAction.ReadOnly] = scala
      .Option(impl.kafka())
      .map(value => zio.aws.iot.model.KafkaAction.wrap(value))
    override val openSearch
        : Option[zio.aws.iot.model.OpenSearchAction.ReadOnly] = scala
      .Option(impl.openSearch())
      .map(value => zio.aws.iot.model.OpenSearchAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Action
  ): zio.aws.iot.model.Action.ReadOnly = new Wrapper(impl)
}
