package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  ViolationId,
  Timestamp,
  SecurityProfileName,
  VerificationStateDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ActiveViolation(
    violationId: Option[ViolationId] = None,
    thingName: Option[DeviceDefenderThingName] = None,
    securityProfileName: Option[SecurityProfileName] = None,
    behavior: Option[zio.aws.iot.model.Behavior] = None,
    lastViolationValue: Option[zio.aws.iot.model.MetricValue] = None,
    violationEventAdditionalInfo: Option[
      zio.aws.iot.model.ViolationEventAdditionalInfo
    ] = None,
    verificationState: Option[zio.aws.iot.model.VerificationState] = None,
    verificationStateDescription: Option[VerificationStateDescription] = None,
    lastViolationTime: Option[Timestamp] = None,
    violationStartTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ActiveViolation = {
    import ActiveViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ActiveViolation
      .builder()
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(behavior.map(value => value.buildAwsValue()))(_.behavior)
      .optionallyWith(lastViolationValue.map(value => value.buildAwsValue()))(
        _.lastViolationValue
      )
      .optionallyWith(
        violationEventAdditionalInfo.map(value => value.buildAwsValue())
      )(_.violationEventAdditionalInfo)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        verificationStateDescription.map(value =>
          VerificationStateDescription.unwrap(value): java.lang.String
        )
      )(_.verificationStateDescription)
      .optionallyWith(
        lastViolationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastViolationTime)
      .optionallyWith(
        violationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.violationStartTime)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ActiveViolation.ReadOnly =
    zio.aws.iot.model.ActiveViolation.wrap(buildAwsValue())
}
object ActiveViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ActiveViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ActiveViolation =
      zio.aws.iot.model.ActiveViolation(
        violationId.map(value => value),
        thingName.map(value => value),
        securityProfileName.map(value => value),
        behavior.map(value => value.asEditable),
        lastViolationValue.map(value => value.asEditable),
        violationEventAdditionalInfo.map(value => value.asEditable),
        verificationState.map(value => value),
        verificationStateDescription.map(value => value),
        lastViolationTime.map(value => value),
        violationStartTime.map(value => value)
      )
    def violationId: Option[ViolationId]
    def thingName: Option[DeviceDefenderThingName]
    def securityProfileName: Option[SecurityProfileName]
    def behavior: Option[zio.aws.iot.model.Behavior.ReadOnly]
    def lastViolationValue: Option[zio.aws.iot.model.MetricValue.ReadOnly]
    def violationEventAdditionalInfo
        : Option[zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly]
    def verificationState: Option[zio.aws.iot.model.VerificationState]
    def verificationStateDescription: Option[VerificationStateDescription]
    def lastViolationTime: Option[Timestamp]
    def violationStartTime: Option[Timestamp]
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehavior: ZIO[Any, AwsError, zio.aws.iot.model.Behavior.ReadOnly] =
      AwsError.unwrapOptionField("behavior", behavior)
    def getLastViolationValue
        : ZIO[Any, AwsError, zio.aws.iot.model.MetricValue.ReadOnly] =
      AwsError.unwrapOptionField("lastViolationValue", lastViolationValue)
    def getViolationEventAdditionalInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "violationEventAdditionalInfo",
      violationEventAdditionalInfo
    )
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.iot.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getVerificationStateDescription
        : ZIO[Any, AwsError, VerificationStateDescription] =
      AwsError.unwrapOptionField(
        "verificationStateDescription",
        verificationStateDescription
      )
    def getLastViolationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastViolationTime", lastViolationTime)
    def getViolationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("violationStartTime", violationStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ActiveViolation
  ) extends zio.aws.iot.model.ActiveViolation.ReadOnly {
    override val violationId: Option[ViolationId] = scala
      .Option(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val thingName: Option[DeviceDefenderThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.DeviceDefenderThingName(value))
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behavior: Option[zio.aws.iot.model.Behavior.ReadOnly] = scala
      .Option(impl.behavior())
      .map(value => zio.aws.iot.model.Behavior.wrap(value))
    override val lastViolationValue
        : Option[zio.aws.iot.model.MetricValue.ReadOnly] = scala
      .Option(impl.lastViolationValue())
      .map(value => zio.aws.iot.model.MetricValue.wrap(value))
    override val violationEventAdditionalInfo
        : Option[zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly] =
      scala
        .Option(impl.violationEventAdditionalInfo())
        .map(value =>
          zio.aws.iot.model.ViolationEventAdditionalInfo.wrap(value)
        )
    override val verificationState
        : Option[zio.aws.iot.model.VerificationState] = scala
      .Option(impl.verificationState())
      .map(value => zio.aws.iot.model.VerificationState.wrap(value))
    override val verificationStateDescription
        : Option[VerificationStateDescription] = scala
      .Option(impl.verificationStateDescription())
      .map(value =>
        zio.aws.iot.model.primitives.VerificationStateDescription(value)
      )
    override val lastViolationTime: Option[Timestamp] = scala
      .Option(impl.lastViolationTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val violationStartTime: Option[Timestamp] = scala
      .Option(impl.violationStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ActiveViolation
  ): zio.aws.iot.model.ActiveViolation.ReadOnly = new Wrapper(impl)
}
