package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AssetPropertyQuality
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssetPropertyValue(
    value: zio.aws.iot.model.AssetPropertyVariant,
    timestamp: zio.aws.iot.model.AssetPropertyTimestamp,
    quality: Option[AssetPropertyQuality] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AssetPropertyValue = {
    import AssetPropertyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AssetPropertyValue
      .builder()
      .value(value.buildAwsValue())
      .timestamp(timestamp.buildAwsValue())
      .optionallyWith(
        quality.map(value =>
          AssetPropertyQuality.unwrap(value): java.lang.String
        )
      )(_.quality)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AssetPropertyValue.ReadOnly =
    zio.aws.iot.model.AssetPropertyValue.wrap(buildAwsValue())
}
object AssetPropertyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AssetPropertyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AssetPropertyValue =
      zio.aws.iot.model.AssetPropertyValue(
        value.asEditable,
        timestamp.asEditable,
        quality.map(value => value)
      )
    def value: zio.aws.iot.model.AssetPropertyVariant.ReadOnly
    def timestamp: zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly
    def quality: Option[AssetPropertyQuality]
    def getValue
        : ZIO[Any, Nothing, zio.aws.iot.model.AssetPropertyVariant.ReadOnly] =
      ZIO.succeed(value)
    def getTimestamp
        : ZIO[Any, Nothing, zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly] =
      ZIO.succeed(timestamp)
    def getQuality: ZIO[Any, AwsError, AssetPropertyQuality] =
      AwsError.unwrapOptionField("quality", quality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyValue
  ) extends zio.aws.iot.model.AssetPropertyValue.ReadOnly {
    override val value: zio.aws.iot.model.AssetPropertyVariant.ReadOnly =
      zio.aws.iot.model.AssetPropertyVariant.wrap(impl.value())
    override val timestamp: zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly =
      zio.aws.iot.model.AssetPropertyTimestamp.wrap(impl.timestamp())
    override val quality: Option[AssetPropertyQuality] = scala
      .Option(impl.quality())
      .map(value => zio.aws.iot.model.primitives.AssetPropertyQuality(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyValue
  ): zio.aws.iot.model.AssetPropertyValue.ReadOnly = new Wrapper(impl)
}
