package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NamespaceId, Comment, JobId, TargetArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssociateTargetsWithJobRequest(
    targets: Iterable[TargetArn],
    jobId: JobId,
    comment: Option[Comment] = None,
    namespaceId: Option[NamespaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest = {
    import AssociateTargetsWithJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest
      .builder()
      .targets(targets.map { item =>
        TargetArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AssociateTargetsWithJobRequest.ReadOnly =
    zio.aws.iot.model.AssociateTargetsWithJobRequest.wrap(buildAwsValue())
}
object AssociateTargetsWithJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AssociateTargetsWithJobRequest =
      zio.aws.iot.model.AssociateTargetsWithJobRequest(
        targets,
        jobId,
        comment.map(value => value),
        namespaceId.map(value => value)
      )
    def targets: List[TargetArn]
    def jobId: JobId
    def comment: Option[Comment]
    def namespaceId: Option[NamespaceId]
    def getTargets: ZIO[Any, Nothing, List[TargetArn]] = ZIO.succeed(targets)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest
  ) extends zio.aws.iot.model.AssociateTargetsWithJobRequest.ReadOnly {
    override val targets: List[TargetArn] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.TargetArn(item)
      }
      .toList
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.iot.model.primitives.Comment(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest
  ): zio.aws.iot.model.AssociateTargetsWithJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
