package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SecurityProfileTargetArn,
  SecurityProfileName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    securityProfileTargetArn: SecurityProfileTargetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest = {
    import AttachSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .securityProfileTargetArn(
        SecurityProfileTargetArn.unwrap(
          securityProfileTargetArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AttachSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.AttachSecurityProfileRequest.wrap(buildAwsValue())
}
object AttachSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AttachSecurityProfileRequest =
      zio.aws.iot.model.AttachSecurityProfileRequest(
        securityProfileName,
        securityProfileTargetArn
      )
    def securityProfileName: SecurityProfileName
    def securityProfileTargetArn: SecurityProfileTargetArn
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getSecurityProfileTargetArn
        : ZIO[Any, Nothing, SecurityProfileTargetArn] =
      ZIO.succeed(securityProfileTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest
  ) extends zio.aws.iot.model.AttachSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val securityProfileTargetArn: SecurityProfileTargetArn =
      zio.aws.iot.model.primitives
        .SecurityProfileTargetArn(impl.securityProfileTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest
  ): zio.aws.iot.model.AttachSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
