package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ErrorMessage,
  TotalResourcesCount,
  NonCompliantResourcesCount,
  ErrorCode,
  SuppressedNonCompliantResourcesCount,
  CheckCompliant
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuditCheckDetails(
    checkRunStatus: Option[zio.aws.iot.model.AuditCheckRunStatus] = None,
    checkCompliant: Option[CheckCompliant] = None,
    totalResourcesCount: Option[TotalResourcesCount] = None,
    nonCompliantResourcesCount: Option[NonCompliantResourcesCount] = None,
    suppressedNonCompliantResourcesCount: Option[
      SuppressedNonCompliantResourcesCount
    ] = None,
    errorCode: Option[ErrorCode] = None,
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditCheckDetails = {
    import AuditCheckDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditCheckDetails
      .builder()
      .optionallyWith(checkRunStatus.map(value => value.unwrap))(
        _.checkRunStatus
      )
      .optionallyWith(
        checkCompliant.map(value =>
          CheckCompliant.unwrap(value): java.lang.Boolean
        )
      )(_.checkCompliant)
      .optionallyWith(
        totalResourcesCount.map(value =>
          TotalResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.totalResourcesCount)
      .optionallyWith(
        nonCompliantResourcesCount.map(value =>
          NonCompliantResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.nonCompliantResourcesCount)
      .optionallyWith(
        suppressedNonCompliantResourcesCount.map(value =>
          SuppressedNonCompliantResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.suppressedNonCompliantResourcesCount)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditCheckDetails.ReadOnly =
    zio.aws.iot.model.AuditCheckDetails.wrap(buildAwsValue())
}
object AuditCheckDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditCheckDetails =
      zio.aws.iot.model.AuditCheckDetails(
        checkRunStatus.map(value => value),
        checkCompliant.map(value => value),
        totalResourcesCount.map(value => value),
        nonCompliantResourcesCount.map(value => value),
        suppressedNonCompliantResourcesCount.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def checkRunStatus: Option[zio.aws.iot.model.AuditCheckRunStatus]
    def checkCompliant: Option[CheckCompliant]
    def totalResourcesCount: Option[TotalResourcesCount]
    def nonCompliantResourcesCount: Option[NonCompliantResourcesCount]
    def suppressedNonCompliantResourcesCount
        : Option[SuppressedNonCompliantResourcesCount]
    def errorCode: Option[ErrorCode]
    def message: Option[ErrorMessage]
    def getCheckRunStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.AuditCheckRunStatus] =
      AwsError.unwrapOptionField("checkRunStatus", checkRunStatus)
    def getCheckCompliant: ZIO[Any, AwsError, CheckCompliant] =
      AwsError.unwrapOptionField("checkCompliant", checkCompliant)
    def getTotalResourcesCount: ZIO[Any, AwsError, TotalResourcesCount] =
      AwsError.unwrapOptionField("totalResourcesCount", totalResourcesCount)
    def getNonCompliantResourcesCount
        : ZIO[Any, AwsError, NonCompliantResourcesCount] =
      AwsError.unwrapOptionField(
        "nonCompliantResourcesCount",
        nonCompliantResourcesCount
      )
    def getSuppressedNonCompliantResourcesCount
        : ZIO[Any, AwsError, SuppressedNonCompliantResourcesCount] =
      AwsError.unwrapOptionField(
        "suppressedNonCompliantResourcesCount",
        suppressedNonCompliantResourcesCount
      )
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ) extends zio.aws.iot.model.AuditCheckDetails.ReadOnly {
    override val checkRunStatus: Option[zio.aws.iot.model.AuditCheckRunStatus] =
      scala
        .Option(impl.checkRunStatus())
        .map(value => zio.aws.iot.model.AuditCheckRunStatus.wrap(value))
    override val checkCompliant: Option[CheckCompliant] = scala
      .Option(impl.checkCompliant())
      .map(value => zio.aws.iot.model.primitives.CheckCompliant(value))
    override val totalResourcesCount: Option[TotalResourcesCount] = scala
      .Option(impl.totalResourcesCount())
      .map(value => zio.aws.iot.model.primitives.TotalResourcesCount(value))
    override val nonCompliantResourcesCount
        : Option[NonCompliantResourcesCount] = scala
      .Option(impl.nonCompliantResourcesCount())
      .map(value =>
        zio.aws.iot.model.primitives.NonCompliantResourcesCount(value)
      )
    override val suppressedNonCompliantResourcesCount
        : Option[SuppressedNonCompliantResourcesCount] = scala
      .Option(impl.suppressedNonCompliantResourcesCount())
      .map(value =>
        zio.aws.iot.model.primitives.SuppressedNonCompliantResourcesCount(value)
      )
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.iot.model.primitives.ErrorCode(value))
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ): zio.aws.iot.model.AuditCheckDetails.ReadOnly = new Wrapper(impl)
}
