package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AuditTaskId,
  ReasonForNonComplianceCode,
  Timestamp,
  AuditCheckName,
  ReasonForNonCompliance,
  IsSuppressed,
  FindingId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AuditFinding(
    findingId: Option[FindingId] = None,
    taskId: Option[AuditTaskId] = None,
    checkName: Option[AuditCheckName] = None,
    taskStartTime: Option[Timestamp] = None,
    findingTime: Option[Timestamp] = None,
    severity: Option[zio.aws.iot.model.AuditFindingSeverity] = None,
    nonCompliantResource: Option[zio.aws.iot.model.NonCompliantResource] = None,
    relatedResources: Option[Iterable[zio.aws.iot.model.RelatedResource]] =
      None,
    reasonForNonCompliance: Option[ReasonForNonCompliance] = None,
    reasonForNonComplianceCode: Option[ReasonForNonComplianceCode] = None,
    isSuppressed: Option[IsSuppressed] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditFinding = {
    import AuditFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditFinding
      .builder()
      .optionallyWith(
        findingId.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.findingId)
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(
        findingTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.findingTime)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(nonCompliantResource.map(value => value.buildAwsValue()))(
        _.nonCompliantResource
      )
      .optionallyWith(
        relatedResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedResources)
      .optionallyWith(
        reasonForNonCompliance.map(value =>
          ReasonForNonCompliance.unwrap(value): java.lang.String
        )
      )(_.reasonForNonCompliance)
      .optionallyWith(
        reasonForNonComplianceCode.map(value =>
          ReasonForNonComplianceCode.unwrap(value): java.lang.String
        )
      )(_.reasonForNonComplianceCode)
      .optionallyWith(
        isSuppressed.map(value => IsSuppressed.unwrap(value): java.lang.Boolean)
      )(_.isSuppressed)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditFinding.ReadOnly =
    zio.aws.iot.model.AuditFinding.wrap(buildAwsValue())
}
object AuditFinding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AuditFinding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditFinding =
      zio.aws.iot.model.AuditFinding(
        findingId.map(value => value),
        taskId.map(value => value),
        checkName.map(value => value),
        taskStartTime.map(value => value),
        findingTime.map(value => value),
        severity.map(value => value),
        nonCompliantResource.map(value => value.asEditable),
        relatedResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reasonForNonCompliance.map(value => value),
        reasonForNonComplianceCode.map(value => value),
        isSuppressed.map(value => value)
      )
    def findingId: Option[FindingId]
    def taskId: Option[AuditTaskId]
    def checkName: Option[AuditCheckName]
    def taskStartTime: Option[Timestamp]
    def findingTime: Option[Timestamp]
    def severity: Option[zio.aws.iot.model.AuditFindingSeverity]
    def nonCompliantResource
        : Option[zio.aws.iot.model.NonCompliantResource.ReadOnly]
    def relatedResources
        : Option[List[zio.aws.iot.model.RelatedResource.ReadOnly]]
    def reasonForNonCompliance: Option[ReasonForNonCompliance]
    def reasonForNonComplianceCode: Option[ReasonForNonComplianceCode]
    def isSuppressed: Option[IsSuppressed]
    def getFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getFindingTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("findingTime", findingTime)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.iot.model.AuditFindingSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getNonCompliantResource
        : ZIO[Any, AwsError, zio.aws.iot.model.NonCompliantResource.ReadOnly] =
      AwsError.unwrapOptionField("nonCompliantResource", nonCompliantResource)
    def getRelatedResources
        : ZIO[Any, AwsError, List[zio.aws.iot.model.RelatedResource.ReadOnly]] =
      AwsError.unwrapOptionField("relatedResources", relatedResources)
    def getReasonForNonCompliance: ZIO[Any, AwsError, ReasonForNonCompliance] =
      AwsError.unwrapOptionField(
        "reasonForNonCompliance",
        reasonForNonCompliance
      )
    def getReasonForNonComplianceCode
        : ZIO[Any, AwsError, ReasonForNonComplianceCode] =
      AwsError.unwrapOptionField(
        "reasonForNonComplianceCode",
        reasonForNonComplianceCode
      )
    def getIsSuppressed: ZIO[Any, AwsError, IsSuppressed] =
      AwsError.unwrapOptionField("isSuppressed", isSuppressed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditFinding
  ) extends zio.aws.iot.model.AuditFinding.ReadOnly {
    override val findingId: Option[FindingId] = scala
      .Option(impl.findingId())
      .map(value => zio.aws.iot.model.primitives.FindingId(value))
    override val taskId: Option[AuditTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val checkName: Option[AuditCheckName] = scala
      .Option(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val taskStartTime: Option[Timestamp] = scala
      .Option(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val findingTime: Option[Timestamp] = scala
      .Option(impl.findingTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val severity: Option[zio.aws.iot.model.AuditFindingSeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.iot.model.AuditFindingSeverity.wrap(value))
    override val nonCompliantResource
        : Option[zio.aws.iot.model.NonCompliantResource.ReadOnly] = scala
      .Option(impl.nonCompliantResource())
      .map(value => zio.aws.iot.model.NonCompliantResource.wrap(value))
    override val relatedResources
        : Option[List[zio.aws.iot.model.RelatedResource.ReadOnly]] = scala
      .Option(impl.relatedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.RelatedResource.wrap(item)
        }.toList
      )
    override val reasonForNonCompliance: Option[ReasonForNonCompliance] = scala
      .Option(impl.reasonForNonCompliance())
      .map(value => zio.aws.iot.model.primitives.ReasonForNonCompliance(value))
    override val reasonForNonComplianceCode
        : Option[ReasonForNonComplianceCode] = scala
      .Option(impl.reasonForNonComplianceCode())
      .map(value =>
        zio.aws.iot.model.primitives.ReasonForNonComplianceCode(value)
      )
    override val isSuppressed: Option[IsSuppressed] = scala
      .Option(impl.isSuppressed())
      .map(value => zio.aws.iot.model.primitives.IsSuppressed(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditFinding
  ): zio.aws.iot.model.AuditFinding.ReadOnly = new Wrapper(impl)
}
