package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait AuditFrequency {
  def unwrap: software.amazon.awssdk.services.iot.model.AuditFrequency
}
object AuditFrequency {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.AuditFrequency
  ): zio.aws.iot.model.AuditFrequency = value match {
    case software.amazon.awssdk.services.iot.model.AuditFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.AuditFrequency.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.iot.model.AuditFrequency.WEEKLY =>
      val r = WEEKLY
      r
    case software.amazon.awssdk.services.iot.model.AuditFrequency.BIWEEKLY =>
      val r = BIWEEKLY
      r
    case software.amazon.awssdk.services.iot.model.AuditFrequency.MONTHLY =>
      val r = MONTHLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.AuditFrequency {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditFrequency =
      software.amazon.awssdk.services.iot.model.AuditFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object DAILY extends zio.aws.iot.model.AuditFrequency {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditFrequency =
      software.amazon.awssdk.services.iot.model.AuditFrequency.DAILY
  }
  case object WEEKLY extends zio.aws.iot.model.AuditFrequency {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditFrequency =
      software.amazon.awssdk.services.iot.model.AuditFrequency.WEEKLY
  }
  case object BIWEEKLY extends zio.aws.iot.model.AuditFrequency {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditFrequency =
      software.amazon.awssdk.services.iot.model.AuditFrequency.BIWEEKLY
  }
  case object MONTHLY extends zio.aws.iot.model.AuditFrequency {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.AuditFrequency =
      software.amazon.awssdk.services.iot.model.AuditFrequency.MONTHLY
  }
}
