package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Resource
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthInfo(
    actionType: Option[zio.aws.iot.model.ActionType] = None,
    resources: Iterable[Resource]
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.AuthInfo = {
    import AuthInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthInfo
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .resources(resources.map { item =>
        Resource.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthInfo.ReadOnly =
    zio.aws.iot.model.AuthInfo.wrap(buildAwsValue())
}
object AuthInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AuthInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthInfo =
      zio.aws.iot.model.AuthInfo(actionType.map(value => value), resources)
    def actionType: Option[zio.aws.iot.model.ActionType]
    def resources: List[Resource]
    def getActionType: ZIO[Any, AwsError, zio.aws.iot.model.ActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getResources: ZIO[Any, Nothing, List[Resource]] = ZIO.succeed(resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthInfo
  ) extends zio.aws.iot.model.AuthInfo.ReadOnly {
    override val actionType: Option[zio.aws.iot.model.ActionType] = scala
      .Option(impl.actionType())
      .map(value => zio.aws.iot.model.ActionType.wrap(value))
    override val resources: List[Resource] = impl
      .resources()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.Resource(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthInfo
  ): zio.aws.iot.model.AuthInfo.ReadOnly = new Wrapper(impl)
}
