package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  KeyValue,
  BooleanKey,
  EnableCachingForHttp,
  DateType,
  KeyName,
  AuthorizerName,
  AuthorizerFunctionArn,
  AuthorizerArn,
  TokenKeyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AuthorizerDescription(
    authorizerName: Option[AuthorizerName] = None,
    authorizerArn: Option[AuthorizerArn] = None,
    authorizerFunctionArn: Option[AuthorizerFunctionArn] = None,
    tokenKeyName: Option[TokenKeyName] = None,
    tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]] = None,
    status: Option[zio.aws.iot.model.AuthorizerStatus] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    signingDisabled: Option[BooleanKey] = None,
    enableCachingForHttp: Option[EnableCachingForHttp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuthorizerDescription = {
    import AuthorizerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthorizerDescription
      .builder()
      .optionallyWith(
        authorizerName.map(value =>
          AuthorizerName.unwrap(value): java.lang.String
        )
      )(_.authorizerName)
      .optionallyWith(
        authorizerArn.map(value =>
          AuthorizerArn.unwrap(value): java.lang.String
        )
      )(_.authorizerArn)
      .optionallyWith(
        authorizerFunctionArn.map(value =>
          AuthorizerFunctionArn.unwrap(value): java.lang.String
        )
      )(_.authorizerFunctionArn)
      .optionallyWith(
        tokenKeyName.map(value => TokenKeyName.unwrap(value): java.lang.String)
      )(_.tokenKeyName)
      .optionallyWith(
        tokenSigningPublicKeys.map(value =>
          value
            .map({ case (key, value) =>
              (KeyName.unwrap(key): java.lang.String) -> (KeyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tokenSigningPublicKeys)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        signingDisabled.map(value =>
          BooleanKey.unwrap(value): java.lang.Boolean
        )
      )(_.signingDisabled)
      .optionallyWith(
        enableCachingForHttp.map(value =>
          EnableCachingForHttp.unwrap(value): java.lang.Boolean
        )
      )(_.enableCachingForHttp)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthorizerDescription.ReadOnly =
    zio.aws.iot.model.AuthorizerDescription.wrap(buildAwsValue())
}
object AuthorizerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthorizerDescription =
      zio.aws.iot.model.AuthorizerDescription(
        authorizerName.map(value => value),
        authorizerArn.map(value => value),
        authorizerFunctionArn.map(value => value),
        tokenKeyName.map(value => value),
        tokenSigningPublicKeys.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        signingDisabled.map(value => value),
        enableCachingForHttp.map(value => value)
      )
    def authorizerName: Option[AuthorizerName]
    def authorizerArn: Option[AuthorizerArn]
    def authorizerFunctionArn: Option[AuthorizerFunctionArn]
    def tokenKeyName: Option[TokenKeyName]
    def tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]]
    def status: Option[zio.aws.iot.model.AuthorizerStatus]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def signingDisabled: Option[BooleanKey]
    def enableCachingForHttp: Option[EnableCachingForHttp]
    def getAuthorizerName: ZIO[Any, AwsError, AuthorizerName] =
      AwsError.unwrapOptionField("authorizerName", authorizerName)
    def getAuthorizerArn: ZIO[Any, AwsError, AuthorizerArn] =
      AwsError.unwrapOptionField("authorizerArn", authorizerArn)
    def getAuthorizerFunctionArn: ZIO[Any, AwsError, AuthorizerFunctionArn] =
      AwsError.unwrapOptionField("authorizerFunctionArn", authorizerFunctionArn)
    def getTokenKeyName: ZIO[Any, AwsError, TokenKeyName] =
      AwsError.unwrapOptionField("tokenKeyName", tokenKeyName)
    def getTokenSigningPublicKeys: ZIO[Any, AwsError, Map[KeyName, KeyValue]] =
      AwsError.unwrapOptionField(
        "tokenSigningPublicKeys",
        tokenSigningPublicKeys
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getSigningDisabled: ZIO[Any, AwsError, BooleanKey] =
      AwsError.unwrapOptionField("signingDisabled", signingDisabled)
    def getEnableCachingForHttp: ZIO[Any, AwsError, EnableCachingForHttp] =
      AwsError.unwrapOptionField("enableCachingForHttp", enableCachingForHttp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ) extends zio.aws.iot.model.AuthorizerDescription.ReadOnly {
    override val authorizerName: Option[AuthorizerName] = scala
      .Option(impl.authorizerName())
      .map(value => zio.aws.iot.model.primitives.AuthorizerName(value))
    override val authorizerArn: Option[AuthorizerArn] = scala
      .Option(impl.authorizerArn())
      .map(value => zio.aws.iot.model.primitives.AuthorizerArn(value))
    override val authorizerFunctionArn: Option[AuthorizerFunctionArn] = scala
      .Option(impl.authorizerFunctionArn())
      .map(value => zio.aws.iot.model.primitives.AuthorizerFunctionArn(value))
    override val tokenKeyName: Option[TokenKeyName] = scala
      .Option(impl.tokenKeyName())
      .map(value => zio.aws.iot.model.primitives.TokenKeyName(value))
    override val tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]] = scala
      .Option(impl.tokenSigningPublicKeys())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .KeyName(key) -> zio.aws.iot.model.primitives.KeyValue(value)
          })
          .toMap
      )
    override val status: Option[zio.aws.iot.model.AuthorizerStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val signingDisabled: Option[BooleanKey] = scala
      .Option(impl.signingDisabled())
      .map(value => zio.aws.iot.model.primitives.BooleanKey(value))
    override val enableCachingForHttp: Option[EnableCachingForHttp] = scala
      .Option(impl.enableCachingForHttp())
      .map(value => zio.aws.iot.model.primitives.EnableCachingForHttp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ): zio.aws.iot.model.AuthorizerDescription.ReadOnly = new Wrapper(impl)
}
