package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ConsecutiveDatapointsToClear,
  ConsecutiveDatapointsToAlarm,
  DurationSeconds
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BehaviorCriteria(
    comparisonOperator: Option[zio.aws.iot.model.ComparisonOperator] = None,
    value: Option[zio.aws.iot.model.MetricValue] = None,
    durationSeconds: Option[DurationSeconds] = None,
    consecutiveDatapointsToAlarm: Option[ConsecutiveDatapointsToAlarm] = None,
    consecutiveDatapointsToClear: Option[ConsecutiveDatapointsToClear] = None,
    statisticalThreshold: Option[zio.aws.iot.model.StatisticalThreshold] = None,
    mlDetectionConfig: Option[
      zio.aws.iot.model.MachineLearningDetectionConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BehaviorCriteria = {
    import BehaviorCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BehaviorCriteria
      .builder()
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(
        durationSeconds.map(value => DurationSeconds.unwrap(value): Integer)
      )(_.durationSeconds)
      .optionallyWith(
        consecutiveDatapointsToAlarm.map(value =>
          ConsecutiveDatapointsToAlarm.unwrap(value): Integer
        )
      )(_.consecutiveDatapointsToAlarm)
      .optionallyWith(
        consecutiveDatapointsToClear.map(value =>
          ConsecutiveDatapointsToClear.unwrap(value): Integer
        )
      )(_.consecutiveDatapointsToClear)
      .optionallyWith(statisticalThreshold.map(value => value.buildAwsValue()))(
        _.statisticalThreshold
      )
      .optionallyWith(mlDetectionConfig.map(value => value.buildAwsValue()))(
        _.mlDetectionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BehaviorCriteria.ReadOnly =
    zio.aws.iot.model.BehaviorCriteria.wrap(buildAwsValue())
}
object BehaviorCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BehaviorCriteria =
      zio.aws.iot.model.BehaviorCriteria(
        comparisonOperator.map(value => value),
        value.map(value => value.asEditable),
        durationSeconds.map(value => value),
        consecutiveDatapointsToAlarm.map(value => value),
        consecutiveDatapointsToClear.map(value => value),
        statisticalThreshold.map(value => value.asEditable),
        mlDetectionConfig.map(value => value.asEditable)
      )
    def comparisonOperator: Option[zio.aws.iot.model.ComparisonOperator]
    def value: Option[zio.aws.iot.model.MetricValue.ReadOnly]
    def durationSeconds: Option[DurationSeconds]
    def consecutiveDatapointsToAlarm: Option[ConsecutiveDatapointsToAlarm]
    def consecutiveDatapointsToClear: Option[ConsecutiveDatapointsToClear]
    def statisticalThreshold
        : Option[zio.aws.iot.model.StatisticalThreshold.ReadOnly]
    def mlDetectionConfig
        : Option[zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly]
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.iot.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getValue: ZIO[Any, AwsError, zio.aws.iot.model.MetricValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getDurationSeconds: ZIO[Any, AwsError, DurationSeconds] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getConsecutiveDatapointsToAlarm
        : ZIO[Any, AwsError, ConsecutiveDatapointsToAlarm] =
      AwsError.unwrapOptionField(
        "consecutiveDatapointsToAlarm",
        consecutiveDatapointsToAlarm
      )
    def getConsecutiveDatapointsToClear
        : ZIO[Any, AwsError, ConsecutiveDatapointsToClear] =
      AwsError.unwrapOptionField(
        "consecutiveDatapointsToClear",
        consecutiveDatapointsToClear
      )
    def getStatisticalThreshold
        : ZIO[Any, AwsError, zio.aws.iot.model.StatisticalThreshold.ReadOnly] =
      AwsError.unwrapOptionField("statisticalThreshold", statisticalThreshold)
    def getMlDetectionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("mlDetectionConfig", mlDetectionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ) extends zio.aws.iot.model.BehaviorCriteria.ReadOnly {
    override val comparisonOperator
        : Option[zio.aws.iot.model.ComparisonOperator] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.iot.model.ComparisonOperator.wrap(value))
    override val value: Option[zio.aws.iot.model.MetricValue.ReadOnly] = scala
      .Option(impl.value())
      .map(value => zio.aws.iot.model.MetricValue.wrap(value))
    override val durationSeconds: Option[DurationSeconds] = scala
      .Option(impl.durationSeconds())
      .map(value => zio.aws.iot.model.primitives.DurationSeconds(value))
    override val consecutiveDatapointsToAlarm
        : Option[ConsecutiveDatapointsToAlarm] = scala
      .Option(impl.consecutiveDatapointsToAlarm())
      .map(value =>
        zio.aws.iot.model.primitives.ConsecutiveDatapointsToAlarm(value)
      )
    override val consecutiveDatapointsToClear
        : Option[ConsecutiveDatapointsToClear] = scala
      .Option(impl.consecutiveDatapointsToClear())
      .map(value =>
        zio.aws.iot.model.primitives.ConsecutiveDatapointsToClear(value)
      )
    override val statisticalThreshold
        : Option[zio.aws.iot.model.StatisticalThreshold.ReadOnly] = scala
      .Option(impl.statisticalThreshold())
      .map(value => zio.aws.iot.model.StatisticalThreshold.wrap(value))
    override val mlDetectionConfig
        : Option[zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly] =
      scala
        .Option(impl.mlDetectionConfig())
        .map(value =>
          zio.aws.iot.model.MachineLearningDetectionConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ): zio.aws.iot.model.BehaviorCriteria.ReadOnly = new Wrapper(impl)
}
