package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{Count, BucketKeyValue}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bucket(
    keyValue: Option[BucketKeyValue] = None,
    count: Option[Count] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Bucket
      .builder()
      .optionallyWith(
        keyValue.map(value => BucketKeyValue.unwrap(value): java.lang.String)
      )(_.keyValue)
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Bucket.ReadOnly =
    zio.aws.iot.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Bucket = zio.aws.iot.model
      .Bucket(keyValue.map(value => value), count.map(value => value))
    def keyValue: Option[BucketKeyValue]
    def count: Option[Count]
    def getKeyValue: ZIO[Any, AwsError, BucketKeyValue] =
      AwsError.unwrapOptionField("keyValue", keyValue)
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Bucket
  ) extends zio.aws.iot.model.Bucket.ReadOnly {
    override val keyValue: Option[BucketKeyValue] = scala
      .Option(impl.keyValue())
      .map(value => zio.aws.iot.model.primitives.BucketKeyValue(value))
    override val count: Option[Count] = scala
      .Option(impl.count())
      .map(value => zio.aws.iot.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Bucket
  ): zio.aws.iot.model.Bucket.ReadOnly = new Wrapper(impl)
}
