package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DateType,
  CertificateId,
  CertificateArn,
  CertificatePem,
  CustomerVersion,
  AwsAccountId,
  GenerationId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CACertificateDescription(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None,
    status: Option[zio.aws.iot.model.CACertificateStatus] = None,
    certificatePem: Option[CertificatePem] = None,
    ownedBy: Option[AwsAccountId] = None,
    creationDate: Option[DateType] = None,
    autoRegistrationStatus: Option[zio.aws.iot.model.AutoRegistrationStatus] =
      None,
    lastModifiedDate: Option[DateType] = None,
    customerVersion: Option[CustomerVersion] = None,
    generationId: Option[GenerationId] = None,
    validity: Option[zio.aws.iot.model.CertificateValidity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CACertificateDescription = {
    import CACertificateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CACertificateDescription
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        ownedBy.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownedBy)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(autoRegistrationStatus.map(value => value.unwrap))(
        _.autoRegistrationStatus
      )
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        customerVersion.map(value => CustomerVersion.unwrap(value): Integer)
      )(_.customerVersion)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CACertificateDescription.ReadOnly =
    zio.aws.iot.model.CACertificateDescription.wrap(buildAwsValue())
}
object CACertificateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CACertificateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CACertificateDescription =
      zio.aws.iot.model.CACertificateDescription(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        status.map(value => value),
        certificatePem.map(value => value),
        ownedBy.map(value => value),
        creationDate.map(value => value),
        autoRegistrationStatus.map(value => value),
        lastModifiedDate.map(value => value),
        customerVersion.map(value => value),
        generationId.map(value => value),
        validity.map(value => value.asEditable)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def status: Option[zio.aws.iot.model.CACertificateStatus]
    def certificatePem: Option[CertificatePem]
    def ownedBy: Option[AwsAccountId]
    def creationDate: Option[DateType]
    def autoRegistrationStatus: Option[zio.aws.iot.model.AutoRegistrationStatus]
    def lastModifiedDate: Option[DateType]
    def customerVersion: Option[CustomerVersion]
    def generationId: Option[GenerationId]
    def validity: Option[zio.aws.iot.model.CertificateValidity.ReadOnly]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CACertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAutoRegistrationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.AutoRegistrationStatus] =
      AwsError.unwrapOptionField(
        "autoRegistrationStatus",
        autoRegistrationStatus
      )
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCustomerVersion: ZIO[Any, AwsError, CustomerVersion] =
      AwsError.unwrapOptionField("customerVersion", customerVersion)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
    def getValidity
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateValidity.ReadOnly] =
      AwsError.unwrapOptionField("validity", validity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CACertificateDescription
  ) extends zio.aws.iot.model.CACertificateDescription.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Option[zio.aws.iot.model.CACertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.CACertificateStatus.wrap(value))
    override val certificatePem: Option[CertificatePem] = scala
      .Option(impl.certificatePem())
      .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val ownedBy: Option[AwsAccountId] = scala
      .Option(impl.ownedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val autoRegistrationStatus
        : Option[zio.aws.iot.model.AutoRegistrationStatus] = scala
      .Option(impl.autoRegistrationStatus())
      .map(value => zio.aws.iot.model.AutoRegistrationStatus.wrap(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val customerVersion: Option[CustomerVersion] = scala
      .Option(impl.customerVersion())
      .map(value => zio.aws.iot.model.primitives.CustomerVersion(value))
    override val generationId: Option[GenerationId] = scala
      .Option(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
    override val validity
        : Option[zio.aws.iot.model.CertificateValidity.ReadOnly] = scala
      .Option(impl.validity())
      .map(value => zio.aws.iot.model.CertificateValidity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CACertificateDescription
  ): zio.aws.iot.model.CACertificateDescription.ReadOnly = new Wrapper(impl)
}
