package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingName,
  DetailsValue,
  ExpectedVersion,
  DetailsKey,
  JobId,
  ForceFlag
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CancelJobExecutionRequest(
    jobId: JobId,
    thingName: ThingName,
    force: Option[ForceFlag] = None,
    expectedVersion: Option[ExpectedVersion] = None,
    statusDetails: Option[Map[DetailsKey, DetailsValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest = {
    import CancelJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        force.map(value => ForceFlag.unwrap(value): java.lang.Boolean)
      )(_.force)
      .optionallyWith(
        expectedVersion.map(value =>
          ExpectedVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        statusDetails.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.statusDetails)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelJobExecutionRequest.ReadOnly =
    zio.aws.iot.model.CancelJobExecutionRequest.wrap(buildAwsValue())
}
object CancelJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelJobExecutionRequest =
      zio.aws.iot.model.CancelJobExecutionRequest(
        jobId,
        thingName,
        force.map(value => value),
        expectedVersion.map(value => value),
        statusDetails.map(value => value)
      )
    def jobId: JobId
    def thingName: ThingName
    def force: Option[ForceFlag]
    def expectedVersion: Option[ExpectedVersion]
    def statusDetails: Option[Map[DetailsKey, DetailsValue]]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getForce: ZIO[Any, AwsError, ForceFlag] =
      AwsError.unwrapOptionField("force", force)
    def getExpectedVersion: ZIO[Any, AwsError, ExpectedVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getStatusDetails: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest
  ) extends zio.aws.iot.model.CancelJobExecutionRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val force: Option[ForceFlag] = scala
      .Option(impl.force())
      .map(value => zio.aws.iot.model.primitives.ForceFlag(value))
    override val expectedVersion: Option[ExpectedVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.ExpectedVersion(value))
    override val statusDetails: Option[Map[DetailsKey, DetailsValue]] = scala
      .Option(impl.statusDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.DetailsKey(
              key
            ) -> zio.aws.iot.model.primitives.DetailsValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest
  ): zio.aws.iot.model.CancelJobExecutionRequest.ReadOnly = new Wrapper(impl)
}
