package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait CannedAccessControlList {
  def unwrap: software.amazon.awssdk.services.iot.model.CannedAccessControlList
}
object CannedAccessControlList {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.CannedAccessControlList
  ): zio.aws.iot.model.CannedAccessControlList = value match {
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
    case software.amazon.awssdk.services.iot.model.CannedAccessControlList.LOG_DELIVERY_WRITE =>
      val r = `log-delivery-write`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.UNKNOWN_TO_SDK_VERSION
  }
  case object `private` extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.PRIVATE
  }
  case object `public-read` extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.PUBLIC_READ
  }
  case object `public-read-write`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.PUBLIC_READ_WRITE
  }
  case object `aws-exec-read`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.AWS_EXEC_READ
  }
  case object `authenticated-read`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.AUTHENTICATED_READ
  }
  case object `bucket-owner-read`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.BUCKET_OWNER_FULL_CONTROL
  }
  case object `log-delivery-write`
      extends zio.aws.iot.model.CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CannedAccessControlList =
      software.amazon.awssdk.services.iot.model.CannedAccessControlList.LOG_DELIVERY_WRITE
  }
}
