package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DateType,
  CertificateId,
  CertificateArn,
  CertificatePem,
  CustomerVersion,
  AwsAccountId,
  GenerationId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CertificateDescription(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None,
    caCertificateId: Option[CertificateId] = None,
    status: Option[zio.aws.iot.model.CertificateStatus] = None,
    certificatePem: Option[CertificatePem] = None,
    ownedBy: Option[AwsAccountId] = None,
    previousOwnedBy: Option[AwsAccountId] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    customerVersion: Option[CustomerVersion] = None,
    transferData: Option[zio.aws.iot.model.TransferData] = None,
    generationId: Option[GenerationId] = None,
    validity: Option[zio.aws.iot.model.CertificateValidity] = None,
    certificateMode: Option[zio.aws.iot.model.CertificateMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CertificateDescription = {
    import CertificateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CertificateDescription
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        caCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.caCertificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        ownedBy.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownedBy)
      .optionallyWith(
        previousOwnedBy.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.previousOwnedBy)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        customerVersion.map(value => CustomerVersion.unwrap(value): Integer)
      )(_.customerVersion)
      .optionallyWith(transferData.map(value => value.buildAwsValue()))(
        _.transferData
      )
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity)
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CertificateDescription.ReadOnly =
    zio.aws.iot.model.CertificateDescription.wrap(buildAwsValue())
}
object CertificateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CertificateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CertificateDescription =
      zio.aws.iot.model.CertificateDescription(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        caCertificateId.map(value => value),
        status.map(value => value),
        certificatePem.map(value => value),
        ownedBy.map(value => value),
        previousOwnedBy.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        customerVersion.map(value => value),
        transferData.map(value => value.asEditable),
        generationId.map(value => value),
        validity.map(value => value.asEditable),
        certificateMode.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def caCertificateId: Option[CertificateId]
    def status: Option[zio.aws.iot.model.CertificateStatus]
    def certificatePem: Option[CertificatePem]
    def ownedBy: Option[AwsAccountId]
    def previousOwnedBy: Option[AwsAccountId]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def customerVersion: Option[CustomerVersion]
    def transferData: Option[zio.aws.iot.model.TransferData.ReadOnly]
    def generationId: Option[GenerationId]
    def validity: Option[zio.aws.iot.model.CertificateValidity.ReadOnly]
    def certificateMode: Option[zio.aws.iot.model.CertificateMode]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCaCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("caCertificateId", caCertificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getPreviousOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("previousOwnedBy", previousOwnedBy)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCustomerVersion: ZIO[Any, AwsError, CustomerVersion] =
      AwsError.unwrapOptionField("customerVersion", customerVersion)
    def getTransferData
        : ZIO[Any, AwsError, zio.aws.iot.model.TransferData.ReadOnly] =
      AwsError.unwrapOptionField("transferData", transferData)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
    def getValidity
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateValidity.ReadOnly] =
      AwsError.unwrapOptionField("validity", validity)
    def getCertificateMode
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateMode] =
      AwsError.unwrapOptionField("certificateMode", certificateMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CertificateDescription
  ) extends zio.aws.iot.model.CertificateDescription.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val caCertificateId: Option[CertificateId] = scala
      .Option(impl.caCertificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Option[zio.aws.iot.model.CertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
    override val certificatePem: Option[CertificatePem] = scala
      .Option(impl.certificatePem())
      .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val ownedBy: Option[AwsAccountId] = scala
      .Option(impl.ownedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val previousOwnedBy: Option[AwsAccountId] = scala
      .Option(impl.previousOwnedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val customerVersion: Option[CustomerVersion] = scala
      .Option(impl.customerVersion())
      .map(value => zio.aws.iot.model.primitives.CustomerVersion(value))
    override val transferData: Option[zio.aws.iot.model.TransferData.ReadOnly] =
      scala
        .Option(impl.transferData())
        .map(value => zio.aws.iot.model.TransferData.wrap(value))
    override val generationId: Option[GenerationId] = scala
      .Option(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
    override val validity
        : Option[zio.aws.iot.model.CertificateValidity.ReadOnly] = scala
      .Option(impl.validity())
      .map(value => zio.aws.iot.model.CertificateValidity.wrap(value))
    override val certificateMode: Option[zio.aws.iot.model.CertificateMode] =
      scala
        .Option(impl.certificateMode())
        .map(value => zio.aws.iot.model.CertificateMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CertificateDescription
  ): zio.aws.iot.model.CertificateDescription.ReadOnly = new Wrapper(impl)
}
