package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DateType
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CertificateValidity(
    notBefore: Option[DateType] = None,
    notAfter: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CertificateValidity = {
    import CertificateValidity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CertificateValidity
      .builder()
      .optionallyWith(notBefore.map(value => DateType.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => DateType.unwrap(value): Instant))(
        _.notAfter
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CertificateValidity.ReadOnly =
    zio.aws.iot.model.CertificateValidity.wrap(buildAwsValue())
}
object CertificateValidity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CertificateValidity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CertificateValidity =
      zio.aws.iot.model.CertificateValidity(
        notBefore.map(value => value),
        notAfter.map(value => value)
      )
    def notBefore: Option[DateType]
    def notAfter: Option[DateType]
    def getNotBefore: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("notAfter", notAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CertificateValidity
  ) extends zio.aws.iot.model.CertificateValidity.ReadOnly {
    override val notBefore: Option[DateType] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val notAfter: Option[DateType] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CertificateValidity
  ): zio.aws.iot.model.CertificateValidity.ReadOnly = new Wrapper(impl)
}
