package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SigningJobId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeSigning(
    awsSignerJobId: Option[SigningJobId] = None,
    startSigningJobParameter: Option[
      zio.aws.iot.model.StartSigningJobParameter
    ] = None,
    customCodeSigning: Option[zio.aws.iot.model.CustomCodeSigning] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.CodeSigning = {
    import CodeSigning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CodeSigning
      .builder()
      .optionallyWith(
        awsSignerJobId.map(value =>
          SigningJobId.unwrap(value): java.lang.String
        )
      )(_.awsSignerJobId)
      .optionallyWith(
        startSigningJobParameter.map(value => value.buildAwsValue())
      )(_.startSigningJobParameter)
      .optionallyWith(customCodeSigning.map(value => value.buildAwsValue()))(
        _.customCodeSigning
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CodeSigning.ReadOnly =
    zio.aws.iot.model.CodeSigning.wrap(buildAwsValue())
}
object CodeSigning {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.CodeSigning] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CodeSigning =
      zio.aws.iot.model.CodeSigning(
        awsSignerJobId.map(value => value),
        startSigningJobParameter.map(value => value.asEditable),
        customCodeSigning.map(value => value.asEditable)
      )
    def awsSignerJobId: Option[SigningJobId]
    def startSigningJobParameter
        : Option[zio.aws.iot.model.StartSigningJobParameter.ReadOnly]
    def customCodeSigning: Option[zio.aws.iot.model.CustomCodeSigning.ReadOnly]
    def getAwsSignerJobId: ZIO[Any, AwsError, SigningJobId] =
      AwsError.unwrapOptionField("awsSignerJobId", awsSignerJobId)
    def getStartSigningJobParameter: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.StartSigningJobParameter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "startSigningJobParameter",
      startSigningJobParameter
    )
    def getCustomCodeSigning
        : ZIO[Any, AwsError, zio.aws.iot.model.CustomCodeSigning.ReadOnly] =
      AwsError.unwrapOptionField("customCodeSigning", customCodeSigning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CodeSigning
  ) extends zio.aws.iot.model.CodeSigning.ReadOnly {
    override val awsSignerJobId: Option[SigningJobId] = scala
      .Option(impl.awsSignerJobId())
      .map(value => zio.aws.iot.model.primitives.SigningJobId(value))
    override val startSigningJobParameter
        : Option[zio.aws.iot.model.StartSigningJobParameter.ReadOnly] = scala
      .Option(impl.startSigningJobParameter())
      .map(value => zio.aws.iot.model.StartSigningJobParameter.wrap(value))
    override val customCodeSigning
        : Option[zio.aws.iot.model.CustomCodeSigning.ReadOnly] = scala
      .Option(impl.customCodeSigning())
      .map(value => zio.aws.iot.model.CustomCodeSigning.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CodeSigning
  ): zio.aws.iot.model.CodeSigning.ReadOnly = new Wrapper(impl)
}
