package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{InlineDocument, CertificateName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeSigningCertificateChain(
    certificateName: Option[CertificateName] = None,
    inlineDocument: Option[InlineDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain = {
    import CodeSigningCertificateChain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
      .builder()
      .optionallyWith(
        certificateName.map(value =>
          CertificateName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(
        inlineDocument.map(value =>
          InlineDocument.unwrap(value): java.lang.String
        )
      )(_.inlineDocument)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly =
    zio.aws.iot.model.CodeSigningCertificateChain.wrap(buildAwsValue())
}
object CodeSigningCertificateChain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CodeSigningCertificateChain =
      zio.aws.iot.model.CodeSigningCertificateChain(
        certificateName.map(value => value),
        inlineDocument.map(value => value)
      )
    def certificateName: Option[CertificateName]
    def inlineDocument: Option[InlineDocument]
    def getCertificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getInlineDocument: ZIO[Any, AwsError, InlineDocument] =
      AwsError.unwrapOptionField("inlineDocument", inlineDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ) extends zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly {
    override val certificateName: Option[CertificateName] = scala
      .Option(impl.certificateName())
      .map(value => zio.aws.iot.model.primitives.CertificateName(value))
    override val inlineDocument: Option[InlineDocument] = scala
      .Option(impl.inlineDocument())
      .map(value => zio.aws.iot.model.primitives.InlineDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain
  ): zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly = new Wrapper(impl)
}
