package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CustomMetricArn, MetricName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCustomMetricResponse(
    metricName: Option[MetricName] = None,
    metricArn: Option[CustomMetricArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse = {
    import CreateCustomMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricArn.map(value => CustomMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly =
    zio.aws.iot.model.CreateCustomMetricResponse.wrap(buildAwsValue())
}
object CreateCustomMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateCustomMetricResponse =
      zio.aws.iot.model.CreateCustomMetricResponse(
        metricName.map(value => value),
        metricArn.map(value => value)
      )
    def metricName: Option[MetricName]
    def metricArn: Option[CustomMetricArn]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricArn: ZIO[Any, AwsError, CustomMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ) extends zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly {
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
    override val metricArn: Option[CustomMetricArn] = scala
      .Option(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.CustomMetricArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ): zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly = new Wrapper(impl)
}
