package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DimensionArn, DimensionName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDimensionResponse(
    name: Option[DimensionName] = None,
    arn: Option[DimensionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDimensionResponse = {
    import CreateDimensionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDimensionResponse
      .builder()
      .optionallyWith(
        name.map(value => DimensionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => DimensionArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDimensionResponse.ReadOnly =
    zio.aws.iot.model.CreateDimensionResponse.wrap(buildAwsValue())
}
object CreateDimensionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDimensionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDimensionResponse =
      zio.aws.iot.model.CreateDimensionResponse(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Option[DimensionName]
    def arn: Option[DimensionArn]
    def getName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, DimensionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDimensionResponse
  ) extends zio.aws.iot.model.CreateDimensionResponse.ReadOnly {
    override val name: Option[DimensionName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val arn: Option[DimensionArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iot.model.primitives.DimensionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDimensionResponse
  ): zio.aws.iot.model.CreateDimensionResponse.ReadOnly = new Wrapper(impl)
}
