package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  QueryVersion,
  QueryString,
  IndexName,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDynamicThingGroupRequest(
    thingGroupName: ThingGroupName,
    thingGroupProperties: Option[zio.aws.iot.model.ThingGroupProperties] = None,
    indexName: Option[IndexName] = None,
    queryString: QueryString,
    queryVersion: Option[QueryVersion] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest = {
    import CreateDynamicThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .optionallyWith(thingGroupProperties.map(value => value.buildAwsValue()))(
        _.thingGroupProperties
      )
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDynamicThingGroupRequest.ReadOnly =
    zio.aws.iot.model.CreateDynamicThingGroupRequest.wrap(buildAwsValue())
}
object CreateDynamicThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDynamicThingGroupRequest =
      zio.aws.iot.model.CreateDynamicThingGroupRequest(
        thingGroupName,
        thingGroupProperties.map(value => value.asEditable),
        indexName.map(value => value),
        queryString,
        queryVersion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def thingGroupName: ThingGroupName
    def thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly]
    def indexName: Option[IndexName]
    def queryString: QueryString
    def queryVersion: Option[QueryVersion]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getThingGroupProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupProperties", thingGroupProperties)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest
  ) extends zio.aws.iot.model.CreateDynamicThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly] = scala
      .Option(impl.thingGroupProperties())
      .map(value => zio.aws.iot.model.ThingGroupProperties.wrap(value))
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest
  ): zio.aws.iot.model.CreateDynamicThingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
