package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  IndexName,
  ThingGroupArn,
  QueryVersion,
  QueryString,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDynamicThingGroupResponse(
    thingGroupName: Option[ThingGroupName] = None,
    thingGroupArn: Option[ThingGroupArn] = None,
    thingGroupId: Option[ThingGroupId] = None,
    indexName: Option[IndexName] = None,
    queryString: Option[QueryString] = None,
    queryVersion: Option[QueryVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse = {
    import CreateDynamicThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly =
    zio.aws.iot.model.CreateDynamicThingGroupResponse.wrap(buildAwsValue())
}
object CreateDynamicThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDynamicThingGroupResponse =
      zio.aws.iot.model.CreateDynamicThingGroupResponse(
        thingGroupName.map(value => value),
        thingGroupArn.map(value => value),
        thingGroupId.map(value => value),
        indexName.map(value => value),
        queryString.map(value => value),
        queryVersion.map(value => value)
      )
    def thingGroupName: Option[ThingGroupName]
    def thingGroupArn: Option[ThingGroupArn]
    def thingGroupId: Option[ThingGroupId]
    def indexName: Option[IndexName]
    def queryString: Option[QueryString]
    def queryVersion: Option[QueryVersion]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ) extends zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly {
    override val thingGroupName: Option[ThingGroupName] = scala
      .Option(impl.thingGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupArn: Option[ThingGroupArn] = scala
      .Option(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val thingGroupId: Option[ThingGroupId] = scala
      .Option(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: Option[QueryString] = scala
      .Option(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ): zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
