package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ParameterKey,
  TargetArn,
  NamespaceId,
  ParameterValue,
  JobTemplateArn,
  JobDocument,
  JobDocumentSource,
  JobId,
  JobDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateJobRequest(
    jobId: JobId,
    targets: Iterable[TargetArn],
    documentSource: Option[JobDocumentSource] = None,
    document: Option[JobDocument] = None,
    description: Option[JobDescription] = None,
    presignedUrlConfig: Option[zio.aws.iot.model.PresignedUrlConfig] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    jobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = None,
    abortConfig: Option[zio.aws.iot.model.AbortConfig] = None,
    timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None,
    namespaceId: Option[NamespaceId] = None,
    jobTemplateArn: Option[JobTemplateArn] = None,
    documentParameters: Option[Map[ParameterKey, ParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .targets(targets.map { item =>
        TargetArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        documentParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.documentParameters)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateJobRequest.ReadOnly =
    zio.aws.iot.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateJobRequest =
      zio.aws.iot.model.CreateJobRequest(
        jobId,
        targets,
        documentSource.map(value => value),
        document.map(value => value),
        description.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        targetSelection.map(value => value),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        namespaceId.map(value => value),
        jobTemplateArn.map(value => value),
        documentParameters.map(value => value)
      )
    def jobId: JobId
    def targets: List[TargetArn]
    def documentSource: Option[JobDocumentSource]
    def document: Option[JobDocument]
    def description: Option[JobDescription]
    def presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def namespaceId: Option[NamespaceId]
    def jobTemplateArn: Option[JobTemplateArn]
    def documentParameters: Option[Map[ParameterKey, ParameterValue]]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getTargets: ZIO[Any, Nothing, List[TargetArn]] = ZIO.succeed(targets)
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getDocumentParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("documentParameters", documentParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateJobRequest
  ) extends zio.aws.iot.model.CreateJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val targets: List[TargetArn] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.TargetArn(item)
      }
      .toList
    override val documentSource: Option[JobDocumentSource] = scala
      .Option(impl.documentSource())
      .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val document: Option[JobDocument] = scala
      .Option(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] = scala
      .Option(impl.presignedUrlConfig())
      .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRolloutConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly] =
      scala
        .Option(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Option[zio.aws.iot.model.TimeoutConfig.ReadOnly] = scala
      .Option(impl.timeoutConfig())
      .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val jobTemplateArn: Option[JobTemplateArn] = scala
      .Option(impl.jobTemplateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val documentParameters: Option[Map[ParameterKey, ParameterValue]] =
      scala
        .Option(impl.documentParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.ParameterKey(
                key
              ) -> zio.aws.iot.model.primitives.ParameterValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateJobRequest
  ): zio.aws.iot.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
