package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SetAsActive
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateKeysAndCertificateRequest(
    setAsActive: Option[SetAsActive] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest = {
    import CreateKeysAndCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest
      .builder()
      .optionallyWith(
        setAsActive.map(value => SetAsActive.unwrap(value): java.lang.Boolean)
      )(_.setAsActive)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateKeysAndCertificateRequest.ReadOnly =
    zio.aws.iot.model.CreateKeysAndCertificateRequest.wrap(buildAwsValue())
}
object CreateKeysAndCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateKeysAndCertificateRequest =
      zio.aws.iot.model
        .CreateKeysAndCertificateRequest(setAsActive.map(value => value))
    def setAsActive: Option[SetAsActive]
    def getSetAsActive: ZIO[Any, AwsError, SetAsActive] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest
  ) extends zio.aws.iot.model.CreateKeysAndCertificateRequest.ReadOnly {
    override val setAsActive: Option[SetAsActive] = scala
      .Option(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest
  ): zio.aws.iot.model.CreateKeysAndCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
