package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  OTAUpdateId,
  RoleArn,
  OTAUpdateDescription,
  Value,
  AttributeKey,
  Target
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOtaUpdateRequest(
    otaUpdateId: OTAUpdateId,
    description: Option[OTAUpdateDescription] = None,
    targets: Iterable[Target],
    protocols: Option[Iterable[zio.aws.iot.model.Protocol]] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    awsJobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig
    ] = None,
    awsJobPresignedUrlConfig: Option[
      zio.aws.iot.model.AwsJobPresignedUrlConfig
    ] = None,
    awsJobAbortConfig: Option[zio.aws.iot.model.AwsJobAbortConfig] = None,
    awsJobTimeoutConfig: Option[zio.aws.iot.model.AwsJobTimeoutConfig] = None,
    files: Iterable[zio.aws.iot.model.OTAUpdateFile],
    roleArn: RoleArn,
    additionalParameters: Option[Map[AttributeKey, Value]] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest = {
    import CreateOtaUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
      .builder()
      .otaUpdateId(OTAUpdateId.unwrap(otaUpdateId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          OTAUpdateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .targets(targets.map { item =>
        Target.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        awsJobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.awsJobExecutionsRolloutConfig)
      .optionallyWith(
        awsJobPresignedUrlConfig.map(value => value.buildAwsValue())
      )(_.awsJobPresignedUrlConfig)
      .optionallyWith(awsJobAbortConfig.map(value => value.buildAwsValue()))(
        _.awsJobAbortConfig
      )
      .optionallyWith(awsJobTimeoutConfig.map(value => value.buildAwsValue()))(
        _.awsJobTimeoutConfig
      )
      .files(files.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        additionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.additionalParameters)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly =
    zio.aws.iot.model.CreateOtaUpdateRequest.wrap(buildAwsValue())
}
object CreateOtaUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateOtaUpdateRequest =
      zio.aws.iot.model.CreateOtaUpdateRequest(
        otaUpdateId,
        description.map(value => value),
        targets,
        protocols.map(value => value),
        targetSelection.map(value => value),
        awsJobExecutionsRolloutConfig.map(value => value.asEditable),
        awsJobPresignedUrlConfig.map(value => value.asEditable),
        awsJobAbortConfig.map(value => value.asEditable),
        awsJobTimeoutConfig.map(value => value.asEditable),
        files.map { item =>
          item.asEditable
        },
        roleArn,
        additionalParameters.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def otaUpdateId: OTAUpdateId
    def description: Option[OTAUpdateDescription]
    def targets: List[Target]
    def protocols: Option[List[zio.aws.iot.model.Protocol]]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def awsJobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly]
    def awsJobPresignedUrlConfig
        : Option[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly]
    def awsJobAbortConfig: Option[zio.aws.iot.model.AwsJobAbortConfig.ReadOnly]
    def awsJobTimeoutConfig
        : Option[zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly]
    def files: List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]
    def roleArn: RoleArn
    def additionalParameters: Option[Map[AttributeKey, Value]]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getOtaUpdateId: ZIO[Any, Nothing, OTAUpdateId] =
      ZIO.succeed(otaUpdateId)
    def getDescription: ZIO[Any, AwsError, OTAUpdateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargets: ZIO[Any, Nothing, List[Target]] = ZIO.succeed(targets)
    def getProtocols: ZIO[Any, AwsError, List[zio.aws.iot.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getAwsJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobExecutionsRolloutConfig",
      awsJobExecutionsRolloutConfig
    )
    def getAwsJobPresignedUrlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobPresignedUrlConfig",
      awsJobPresignedUrlConfig
    )
    def getAwsJobAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AwsJobAbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("awsJobAbortConfig", awsJobAbortConfig)
    def getAwsJobTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("awsJobTimeoutConfig", awsJobTimeoutConfig)
    def getFiles
        : ZIO[Any, Nothing, List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]] =
      ZIO.succeed(files)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getAdditionalParameters: ZIO[Any, AwsError, Map[AttributeKey, Value]] =
      AwsError.unwrapOptionField("additionalParameters", additionalParameters)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ) extends zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly {
    override val otaUpdateId: OTAUpdateId =
      zio.aws.iot.model.primitives.OTAUpdateId(impl.otaUpdateId())
    override val description: Option[OTAUpdateDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateDescription(value))
    override val targets: List[Target] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.Target(item)
      }
      .toList
    override val protocols: Option[List[zio.aws.iot.model.Protocol]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Protocol.wrap(item)
        }.toList
      )
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val awsJobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly] =
      scala
        .Option(impl.awsJobExecutionsRolloutConfig())
        .map(value =>
          zio.aws.iot.model.AwsJobExecutionsRolloutConfig.wrap(value)
        )
    override val awsJobPresignedUrlConfig
        : Option[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly] = scala
      .Option(impl.awsJobPresignedUrlConfig())
      .map(value => zio.aws.iot.model.AwsJobPresignedUrlConfig.wrap(value))
    override val awsJobAbortConfig
        : Option[zio.aws.iot.model.AwsJobAbortConfig.ReadOnly] = scala
      .Option(impl.awsJobAbortConfig())
      .map(value => zio.aws.iot.model.AwsJobAbortConfig.wrap(value))
    override val awsJobTimeoutConfig
        : Option[zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly] = scala
      .Option(impl.awsJobTimeoutConfig())
      .map(value => zio.aws.iot.model.AwsJobTimeoutConfig.wrap(value))
    override val files: List[zio.aws.iot.model.OTAUpdateFile.ReadOnly] = impl
      .files()
      .asScala
      .map { item =>
        zio.aws.iot.model.OTAUpdateFile.wrap(item)
      }
      .toList
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
    override val additionalParameters: Option[Map[AttributeKey, Value]] = scala
      .Option(impl.additionalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .AttributeKey(key) -> zio.aws.iot.model.primitives.Value(value)
          })
          .toMap
      )
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ): zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly = new Wrapper(impl)
}
