package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsIotJobArn,
  OTAUpdateArn,
  AwsIotJobId,
  OTAUpdateId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOtaUpdateResponse(
    otaUpdateId: Option[OTAUpdateId] = None,
    awsIotJobId: Option[AwsIotJobId] = None,
    otaUpdateArn: Option[OTAUpdateArn] = None,
    awsIotJobArn: Option[AwsIotJobArn] = None,
    otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse = {
    import CreateOtaUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
      .builder()
      .optionallyWith(
        otaUpdateId.map(value => OTAUpdateId.unwrap(value): java.lang.String)
      )(_.otaUpdateId)
      .optionallyWith(
        awsIotJobId.map(value => AwsIotJobId.unwrap(value): java.lang.String)
      )(_.awsIotJobId)
      .optionallyWith(
        otaUpdateArn.map(value => OTAUpdateArn.unwrap(value): java.lang.String)
      )(_.otaUpdateArn)
      .optionallyWith(
        awsIotJobArn.map(value => AwsIotJobArn.unwrap(value): java.lang.String)
      )(_.awsIotJobArn)
      .optionallyWith(otaUpdateStatus.map(value => value.unwrap))(
        _.otaUpdateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly =
    zio.aws.iot.model.CreateOtaUpdateResponse.wrap(buildAwsValue())
}
object CreateOtaUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateOtaUpdateResponse =
      zio.aws.iot.model.CreateOtaUpdateResponse(
        otaUpdateId.map(value => value),
        awsIotJobId.map(value => value),
        otaUpdateArn.map(value => value),
        awsIotJobArn.map(value => value),
        otaUpdateStatus.map(value => value)
      )
    def otaUpdateId: Option[OTAUpdateId]
    def awsIotJobId: Option[AwsIotJobId]
    def otaUpdateArn: Option[OTAUpdateArn]
    def awsIotJobArn: Option[AwsIotJobArn]
    def otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus]
    def getOtaUpdateId: ZIO[Any, AwsError, OTAUpdateId] =
      AwsError.unwrapOptionField("otaUpdateId", otaUpdateId)
    def getAwsIotJobId: ZIO[Any, AwsError, AwsIotJobId] =
      AwsError.unwrapOptionField("awsIotJobId", awsIotJobId)
    def getOtaUpdateArn: ZIO[Any, AwsError, OTAUpdateArn] =
      AwsError.unwrapOptionField("otaUpdateArn", otaUpdateArn)
    def getAwsIotJobArn: ZIO[Any, AwsError, AwsIotJobArn] =
      AwsError.unwrapOptionField("awsIotJobArn", awsIotJobArn)
    def getOtaUpdateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateStatus] =
      AwsError.unwrapOptionField("otaUpdateStatus", otaUpdateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ) extends zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly {
    override val otaUpdateId: Option[OTAUpdateId] = scala
      .Option(impl.otaUpdateId())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateId(value))
    override val awsIotJobId: Option[AwsIotJobId] = scala
      .Option(impl.awsIotJobId())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobId(value))
    override val otaUpdateArn: Option[OTAUpdateArn] = scala
      .Option(impl.otaUpdateArn())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateArn(value))
    override val awsIotJobArn: Option[AwsIotJobArn] = scala
      .Option(impl.awsIotJobArn())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobArn(value))
    override val otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] =
      scala
        .Option(impl.otaUpdateStatus())
        .map(value => zio.aws.iot.model.OTAUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ): zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly = new Wrapper(impl)
}
