package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  PolicyVersionId,
  PolicyDocument,
  PolicyArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePolicyVersionResponse(
    policyArn: Option[PolicyArn] = None,
    policyDocument: Option[PolicyDocument] = None,
    policyVersionId: Option[PolicyVersionId] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse = {
    import CreatePolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
      .builder()
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly =
    zio.aws.iot.model.CreatePolicyVersionResponse.wrap(buildAwsValue())
}
object CreatePolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreatePolicyVersionResponse =
      zio.aws.iot.model.CreatePolicyVersionResponse(
        policyArn.map(value => value),
        policyDocument.map(value => value),
        policyVersionId.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def policyArn: Option[PolicyArn]
    def policyDocument: Option[PolicyDocument]
    def policyVersionId: Option[PolicyVersionId]
    def isDefaultVersion: Option[IsDefaultVersion]
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ) extends zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly {
    override val policyArn: Option[PolicyArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Option[PolicyDocument] = scala
      .Option(impl.policyDocument())
      .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val policyVersionId: Option[PolicyVersionId] = scala
      .Option(impl.policyVersionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ): zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly = new Wrapper(impl)
}
