package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  TemplateVersionId,
  TemplateName,
  TemplateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateProvisioningTemplateVersionResponse(
    templateArn: Option[TemplateArn] = None,
    templateName: Option[TemplateName] = None,
    versionId: Option[TemplateVersionId] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse = {
    import CreateProvisioningTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        versionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly =
    zio.aws.iot.model.CreateProvisioningTemplateVersionResponse
      .wrap(buildAwsValue())
}
object CreateProvisioningTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.CreateProvisioningTemplateVersionResponse =
      zio.aws.iot.model.CreateProvisioningTemplateVersionResponse(
        templateArn.map(value => value),
        templateName.map(value => value),
        versionId.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def templateArn: Option[TemplateArn]
    def templateName: Option[TemplateName]
    def versionId: Option[TemplateVersionId]
    def isDefaultVersion: Option[IsDefaultVersion]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ) extends zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly {
    override val templateArn: Option[TemplateArn] = scala
      .Option(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Option[TemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val versionId: Option[TemplateVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ): zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
