package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, StreamDescription, StreamId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateStreamRequest(
    streamId: StreamId,
    description: Option[StreamDescription] = None,
    files: Iterable[zio.aws.iot.model.StreamFile],
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateStreamRequest = {
    import CreateStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateStreamRequest
      .builder()
      .streamId(StreamId.unwrap(streamId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .files(files.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateStreamRequest.ReadOnly =
    zio.aws.iot.model.CreateStreamRequest.wrap(buildAwsValue())
}
object CreateStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateStreamRequest =
      zio.aws.iot.model.CreateStreamRequest(
        streamId,
        description.map(value => value),
        files.map { item =>
          item.asEditable
        },
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def streamId: StreamId
    def description: Option[StreamDescription]
    def files: List[zio.aws.iot.model.StreamFile.ReadOnly]
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getStreamId: ZIO[Any, Nothing, StreamId] = ZIO.succeed(streamId)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFiles
        : ZIO[Any, Nothing, List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      ZIO.succeed(files)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateStreamRequest
  ) extends zio.aws.iot.model.CreateStreamRequest.ReadOnly {
    override val streamId: StreamId =
      zio.aws.iot.model.primitives.StreamId(impl.streamId())
    override val description: Option[StreamDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val files: List[zio.aws.iot.model.StreamFile.ReadOnly] = impl
      .files()
      .asScala
      .map { item =>
        zio.aws.iot.model.StreamFile.wrap(item)
      }
      .toList
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateStreamRequest
  ): zio.aws.iot.model.CreateStreamRequest.ReadOnly = new Wrapper(impl)
}
